/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.annotation.UnsupportedAppUsage;
import android.filterfw.core.NativeAllocatorTag;
import android.graphics.SurfaceTexture;
import android.media.MediaRecorder;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;

public class GLEnvironment {
    private int glEnvId;
    private boolean mManageContext = true;

    public GLEnvironment() {
        this.nativeAllocate();
    }

    private GLEnvironment(NativeAllocatorTag tag) {
    }

    public synchronized void tearDown() {
        if (this.glEnvId != -1) {
            this.nativeDeallocate();
            this.glEnvId = -1;
        }
    }

    protected void finalize() throws Throwable {
        this.tearDown();
    }

    public void initWithNewContext() {
        this.mManageContext = true;
        if (!this.nativeInitWithNewContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with new context!");
        }
    }

    public void initWithCurrentContext() {
        this.mManageContext = false;
        if (!this.nativeInitWithCurrentContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with current context!");
        }
    }

    @UnsupportedAppUsage
    public boolean isActive() {
        return this.nativeIsActive();
    }

    public boolean isContextActive() {
        return this.nativeIsContextActive();
    }

    public static boolean isAnyContextActive() {
        return GLEnvironment.nativeIsAnyContextActive();
    }

    @UnsupportedAppUsage
    public void activate() {
        if (Looper.myLooper() != null && Looper.myLooper().equals(Looper.getMainLooper())) {
            Log.e("FilterFramework", "Activating GL context in UI thread!");
        }
        if (this.mManageContext && !this.nativeActivate()) {
            throw new RuntimeException("Could not activate GLEnvironment!");
        }
    }

    @UnsupportedAppUsage
    public void deactivate() {
        if (this.mManageContext && !this.nativeDeactivate()) {
            throw new RuntimeException("Could not deactivate GLEnvironment!");
        }
    }

    @UnsupportedAppUsage
    public void swapBuffers() {
        if (!this.nativeSwapBuffers()) {
            throw new RuntimeException("Error swapping EGL buffers!");
        }
    }

    public int registerSurface(Surface surface) {
        int result = this.nativeAddSurface(surface);
        if (result < 0) {
            throw new RuntimeException("Error registering surface " + surface + "!");
        }
        return result;
    }

    public int registerSurfaceTexture(SurfaceTexture surfaceTexture, int width, int height) {
        Surface surface = new Surface(surfaceTexture);
        int result = this.nativeAddSurfaceWidthHeight(surface, width, height);
        surface.release();
        if (result < 0) {
            throw new RuntimeException("Error registering surfaceTexture " + surfaceTexture + "!");
        }
        return result;
    }

    @UnsupportedAppUsage
    public int registerSurfaceFromMediaRecorder(MediaRecorder mediaRecorder) {
        int result = this.nativeAddSurfaceFromMediaRecorder(mediaRecorder);
        if (result < 0) {
            throw new RuntimeException("Error registering surface from MediaRecorder" + mediaRecorder + "!");
        }
        return result;
    }

    @UnsupportedAppUsage
    public void activateSurfaceWithId(int surfaceId) {
        if (!this.nativeActivateSurfaceId(surfaceId)) {
            throw new RuntimeException("Could not activate surface " + surfaceId + "!");
        }
    }

    @UnsupportedAppUsage
    public void unregisterSurfaceId(int surfaceId) {
        if (!this.nativeRemoveSurfaceId(surfaceId)) {
            throw new RuntimeException("Could not unregister surface " + surfaceId + "!");
        }
    }

    @UnsupportedAppUsage
    public void setSurfaceTimestamp(long timestamp) {
        if (!this.nativeSetSurfaceTimestamp(timestamp)) {
            throw new RuntimeException("Could not set timestamp for current surface!");
        }
    }

    private native boolean nativeInitWithNewContext();

    private native boolean nativeInitWithCurrentContext();

    private native boolean nativeIsActive();

    private native boolean nativeIsContextActive();

    private static native boolean nativeIsAnyContextActive();

    private native boolean nativeActivate();

    private native boolean nativeDeactivate();

    private native boolean nativeSwapBuffers();

    private native boolean nativeAllocate();

    private native boolean nativeDeallocate();

    private native int nativeAddSurface(Surface var1);

    private native int nativeAddSurfaceWidthHeight(Surface var1, int var2, int var3);

    private native int nativeAddSurfaceFromMediaRecorder(MediaRecorder var1);

    private native boolean nativeDisconnectSurfaceMediaSource(MediaRecorder var1);

    private native boolean nativeActivateSurfaceId(int var1);

    private native boolean nativeRemoveSurfaceId(int var1);

    private native boolean nativeSetSurfaceTimestamp(long var1);

    static {
        System.loadLibrary("filterfw");
    }
}

