/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;

public class NativeBuffer {
    private long mDataPointer = 0L;
    private int mSize = 0;
    private Frame mAttachedFrame;
    private boolean mOwnsData = false;
    private int mRefCount = 1;

    public NativeBuffer() {
    }

    public NativeBuffer(int count) {
        this.allocate(count * this.getElementSize());
        this.mOwnsData = true;
    }

    public NativeBuffer mutableCopy() {
        NativeBuffer result = null;
        try {
            Class<?> myClass = this.getClass();
            result = (NativeBuffer)myClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to allocate a copy of " + this.getClass() + "! Make sure the class has a default constructor!");
        }
        if (this.mSize > 0 && !this.nativeCopyTo(result)) {
            throw new RuntimeException("Failed to copy NativeBuffer to mutable instance!");
        }
        return result;
    }

    public int size() {
        return this.mSize;
    }

    public int count() {
        return this.mDataPointer != 0L ? this.mSize / this.getElementSize() : 0;
    }

    public int getElementSize() {
        return 1;
    }

    public NativeBuffer retain() {
        if (this.mAttachedFrame != null) {
            this.mAttachedFrame.retain();
        } else if (this.mOwnsData) {
            ++this.mRefCount;
        }
        return this;
    }

    public NativeBuffer release() {
        boolean doDealloc = false;
        if (this.mAttachedFrame != null) {
            doDealloc = this.mAttachedFrame.release() == null;
        } else if (this.mOwnsData) {
            --this.mRefCount;
            boolean bl = doDealloc = this.mRefCount == 0;
        }
        if (doDealloc) {
            this.deallocate(this.mOwnsData);
            return null;
        }
        return this;
    }

    public boolean isReadOnly() {
        return this.mAttachedFrame != null ? this.mAttachedFrame.isReadOnly() : false;
    }

    void attachToFrame(Frame frame) {
        this.mAttachedFrame = frame;
    }

    protected void assertReadable() {
        if (this.mDataPointer == 0L || this.mSize == 0 || this.mAttachedFrame != null && !this.mAttachedFrame.hasNativeAllocation()) {
            throw new NullPointerException("Attempting to read from null data frame!");
        }
    }

    protected void assertWritable() {
        if (this.isReadOnly()) {
            throw new RuntimeException("Attempting to modify read-only native (structured) data!");
        }
    }

    private native boolean allocate(int var1);

    private native boolean deallocate(boolean var1);

    private native boolean nativeCopyTo(NativeBuffer var1);

    static {
        System.loadLibrary("filterfw");
    }
}

