/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.Scheduler;
import java.util.Set;

public class RoundRobinScheduler
extends Scheduler {
    private int mLastPos = -1;

    public RoundRobinScheduler(FilterGraph graph) {
        super(graph);
    }

    @Override
    public void reset() {
        this.mLastPos = -1;
    }

    @Override
    public Filter scheduleNextNode() {
        Set<Filter> all_filters = this.getGraph().getFilters();
        if (this.mLastPos >= all_filters.size()) {
            this.mLastPos = -1;
        }
        int pos = 0;
        Filter first = null;
        int firstNdx = -1;
        for (Filter filter : all_filters) {
            if (filter.canProcess()) {
                if (pos <= this.mLastPos) {
                    if (first == null) {
                        first = filter;
                        firstNdx = pos;
                    }
                } else {
                    this.mLastPos = pos;
                    return filter;
                }
            }
            ++pos;
        }
        if (first != null) {
            this.mLastPos = firstNdx;
            return first;
        }
        return null;
    }
}

