/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class RotateFilter
extends Filter {
    @GenerateFieldPort(name="angle")
    private int mAngle;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize = 640;
    private Program mProgram;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mTarget = 0;
    private int mOutputWidth;
    private int mOutputHeight;

    public RotateFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    public void initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = ShaderProgram.createIdentity(context);
                shaderProgram.setMaximumTileSize(this.mTileSize);
                shaderProgram.setClearsOutput(true);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    @Override
    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.mWidth = inputFormat.getWidth();
            this.mHeight = inputFormat.getHeight();
            this.mOutputWidth = this.mWidth;
            this.mOutputHeight = this.mHeight;
            this.updateParameters();
        }
        MutableFrameFormat outputFormat = ImageFormat.create(this.mOutputWidth, this.mOutputHeight, 3, 3);
        Frame output = context.getFrameManager().newFrame(outputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private void updateParameters() {
        float cosTheta;
        float sinTheta;
        if (this.mAngle % 90 == 0) {
            if (this.mAngle % 180 == 0) {
                sinTheta = 0.0f;
                cosTheta = this.mAngle % 360 == 0 ? 1.0f : -1.0f;
            } else {
                cosTheta = 0.0f;
                sinTheta = (this.mAngle + 90) % 360 == 0 ? -1.0f : 1.0f;
                this.mOutputWidth = this.mHeight;
                this.mOutputHeight = this.mWidth;
            }
        } else {
            throw new RuntimeException("degree has to be multiply of 90.");
        }
        Point x0 = new Point(0.5f * (-cosTheta + sinTheta + 1.0f), 0.5f * (-sinTheta - cosTheta + 1.0f));
        Point x1 = new Point(0.5f * (cosTheta + sinTheta + 1.0f), 0.5f * (sinTheta - cosTheta + 1.0f));
        Point x2 = new Point(0.5f * (-cosTheta - sinTheta + 1.0f), 0.5f * (-sinTheta + cosTheta + 1.0f));
        Point x3 = new Point(0.5f * (cosTheta - sinTheta + 1.0f), 0.5f * (sinTheta + cosTheta + 1.0f));
        Quad quad = new Quad(x0, x1, x2, x3);
        ((ShaderProgram)this.mProgram).setTargetRegion(quad);
    }
}

