/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.fonts.FontVariationAxis;
import android.text.TextUtils;
import android.util.Log;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import libcore.util.NativeAllocationRegistry;

@Deprecated
public class FontFamily {
    private static String TAG = "FontFamily";
    private static final NativeAllocationRegistry sBuilderRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetBuilderReleaseFunc());
    private Runnable mNativeBuilderCleaner;
    private static final NativeAllocationRegistry sFamilyRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetFamilyReleaseFunc());
    @UnsupportedAppUsage(trackingBug=123768928L)
    public long mNativePtr;
    private long mBuilderPtr;

    @UnsupportedAppUsage(trackingBug=123768928L)
    public FontFamily() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public FontFamily(String[] langs, int variant) {
        String langsString = langs == null || langs.length == 0 ? null : (langs.length == 1 ? langs[0] : TextUtils.join((CharSequence)",", langs));
        this.mBuilderPtr = FontFamily.nInitBuilder(langsString, variant);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
        if (this.mNativePtr != 0L) {
            sFamilyRegistry.registerNativeAllocation(this, this.mNativePtr);
        }
        return this.mNativePtr != 0L;
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public void abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFont(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, ttcIndex, weight, isItalic);
    }

    private static boolean nAddFont(long builderPtr, ByteBuffer font, int ttcIndex) {
        return FontFamily.nAddFont(builderPtr, font, ttcIndex, -1, -1);
    }

    private static native long nInitBuilder(String var0, int var1);

    @CriticalNative
    private static native long nCreateFamily(long var0);

    @CriticalNative
    private static native long nGetBuilderReleaseFunc();

    @CriticalNative
    private static native long nGetFamilyReleaseFunc();

    private static native boolean nAddFont(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native boolean nAddFontWeightStyle(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native boolean nAddFontFromAssetManager(long var0, AssetManager var2, String var3, int var4, boolean var5, int var6, int var7, int var8);

    @CriticalNative
    private static native void nAddAxisValue(long var0, int var2, float var3);
}

