/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.drawable.RippleComponent;
import android.graphics.drawable.RippleDrawable;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.view.RenderNodeAnimator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import java.util.ArrayList;

class RippleForeground
extends RippleComponent {
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final TimeInterpolator DECELERATE_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private static final int RIPPLE_ENTER_DURATION = 225;
    private static final int RIPPLE_ORIGIN_DURATION = 225;
    private static final int OPACITY_ENTER_DURATION = 75;
    private static final int OPACITY_EXIT_DURATION = 150;
    private static final int OPACITY_HOLD_DURATION = 225;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private float mTargetX = 0.0f;
    private float mTargetY = 0.0f;
    private float mOpacity = 0.0f;
    private float mTweenRadius = 0.0f;
    private float mTweenX = 0.0f;
    private float mTweenY = 0.0f;
    private boolean mHasFinishedExit;
    private boolean mUsingProperties;
    private long mEnterStartedAtMillis;
    private ArrayList<RenderNodeAnimator> mPendingHwAnimators = new ArrayList();
    private ArrayList<RenderNodeAnimator> mRunningHwAnimators = new ArrayList();
    private ArrayList<Animator> mRunningSwAnimators = new ArrayList();
    private final boolean mForceSoftware;
    private float mStartRadius = 0.0f;
    private final AnimatorListenerAdapter mAnimationListener = new AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(Animator animator2) {
            RippleForeground.this.mHasFinishedExit = true;
            RippleForeground.this.pruneHwFinished();
            RippleForeground.this.pruneSwFinished();
            if (RippleForeground.this.mRunningHwAnimators.isEmpty()) {
                RippleForeground.this.clearHwProps();
            }
        }
    };
    private static final FloatProperty<RippleForeground> TWEEN_RADIUS = new FloatProperty<RippleForeground>("tweenRadius"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mTweenRadius = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mTweenRadius);
        }
    };
    private static final FloatProperty<RippleForeground> TWEEN_ORIGIN = new FloatProperty<RippleForeground>("tweenOrigin"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mTweenX = value;
            object.mTweenY = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mTweenX);
        }
    };
    private static final FloatProperty<RippleForeground> OPACITY = new FloatProperty<RippleForeground>("opacity"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mOpacity = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mOpacity);
        }
    };

    public RippleForeground(RippleDrawable owner, Rect bounds, float startingX, float startingY, boolean forceSoftware) {
        super(owner, bounds);
        this.mForceSoftware = forceSoftware;
        this.mStartingX = startingX;
        this.mStartingY = startingY;
        this.mStartRadius = (float)Math.max(bounds.width(), bounds.height()) * 0.3f;
        this.clampStartingPosition();
    }

    @Override
    protected void onTargetRadiusChanged(float targetRadius) {
        this.clampStartingPosition();
        this.switchToUiThreadAnimation();
    }

    private void drawSoftware(Canvas c, Paint p) {
        int origAlpha = p.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        float radius = this.getCurrentRadius();
        if (alpha > 0 && radius > 0.0f) {
            float x = this.getCurrentX();
            float y = this.getCurrentY();
            p.setAlpha(alpha);
            c.drawCircle(x, y, radius, p);
            p.setAlpha(origAlpha);
        }
    }

    private void startPending(RecordingCanvas c) {
        if (!this.mPendingHwAnimators.isEmpty()) {
            for (int i = 0; i < this.mPendingHwAnimators.size(); ++i) {
                RenderNodeAnimator animator2 = this.mPendingHwAnimators.get(i);
                animator2.setTarget(c);
                animator2.start();
                this.mRunningHwAnimators.add(animator2);
            }
            this.mPendingHwAnimators.clear();
        }
    }

    private void pruneHwFinished() {
        if (!this.mRunningHwAnimators.isEmpty()) {
            for (int i = this.mRunningHwAnimators.size() - 1; i >= 0; --i) {
                if (this.mRunningHwAnimators.get(i).isRunning()) continue;
                this.mRunningHwAnimators.remove(i);
            }
        }
    }

    private void pruneSwFinished() {
        if (!this.mRunningSwAnimators.isEmpty()) {
            for (int i = this.mRunningSwAnimators.size() - 1; i >= 0; --i) {
                if (this.mRunningSwAnimators.get(i).isRunning()) continue;
                this.mRunningSwAnimators.remove(i);
            }
        }
    }

    private void drawHardware(RecordingCanvas c, Paint p) {
        this.startPending(c);
        this.pruneHwFinished();
        if (this.mPropPaint != null) {
            this.mUsingProperties = true;
            c.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        } else {
            this.mUsingProperties = false;
            this.drawSoftware(c, p);
        }
    }

    @Override
    public void getBounds(Rect bounds) {
        int outerX = (int)this.mTargetX;
        int outerY = (int)this.mTargetY;
        int r = (int)this.mTargetRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    public void move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    public boolean hasFinishedExit() {
        return this.mHasFinishedExit;
    }

    private long computeFadeOutDelay() {
        long timeSinceEnter = AnimationUtils.currentAnimationTimeMillis() - this.mEnterStartedAtMillis;
        if (timeSinceEnter > 0L && timeSinceEnter < 225L) {
            return 225L - timeSinceEnter;
        }
        return 0L;
    }

    private void startSoftwareEnter() {
        for (int i = 0; i < this.mRunningSwAnimators.size(); ++i) {
            this.mRunningSwAnimators.get(i).cancel();
        }
        this.mRunningSwAnimators.clear();
        ObjectAnimator tweenRadius = ObjectAnimator.ofFloat(this, TWEEN_RADIUS, 1.0f);
        tweenRadius.setDuration(225L);
        tweenRadius.setInterpolator(DECELERATE_INTERPOLATOR);
        tweenRadius.start();
        this.mRunningSwAnimators.add(tweenRadius);
        ObjectAnimator tweenOrigin = ObjectAnimator.ofFloat(this, TWEEN_ORIGIN, 1.0f);
        tweenOrigin.setDuration(225L);
        tweenOrigin.setInterpolator(DECELERATE_INTERPOLATOR);
        tweenOrigin.start();
        this.mRunningSwAnimators.add(tweenOrigin);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
        opacity.setDuration(75L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.start();
        this.mRunningSwAnimators.add(opacity);
    }

    private void startSoftwareExit() {
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 0.0f);
        opacity.setDuration(150L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.addListener(this.mAnimationListener);
        opacity.setStartDelay(this.computeFadeOutDelay());
        opacity.start();
        this.mRunningSwAnimators.add(opacity);
    }

    private void startHardwareEnter() {
        if (this.mForceSoftware) {
            return;
        }
        this.mPropX = CanvasProperty.createFloat(this.getCurrentX());
        this.mPropY = CanvasProperty.createFloat(this.getCurrentY());
        this.mPropRadius = CanvasProperty.createFloat(this.getCurrentRadius());
        Paint paint = this.mOwner.getRipplePaint();
        this.mPropPaint = CanvasProperty.createPaint(paint);
        RenderNodeAnimator radius = new RenderNodeAnimator(this.mPropRadius, this.mTargetRadius);
        radius.setDuration(225L);
        radius.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(radius);
        RenderNodeAnimator x = new RenderNodeAnimator(this.mPropX, this.mTargetX);
        x.setDuration(225L);
        x.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(x);
        RenderNodeAnimator y = new RenderNodeAnimator(this.mPropY, this.mTargetY);
        y.setDuration(225L);
        y.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(y);
        RenderNodeAnimator opacity = new RenderNodeAnimator(this.mPropPaint, 1, paint.getAlpha());
        opacity.setDuration(75L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.setStartValue(0.0f);
        this.mPendingHwAnimators.add(opacity);
        this.invalidateSelf();
    }

    private void startHardwareExit() {
        if (this.mForceSoftware || this.mPropPaint == null) {
            return;
        }
        RenderNodeAnimator opacity = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        opacity.setDuration(150L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.addListener(this.mAnimationListener);
        opacity.setStartDelay(this.computeFadeOutDelay());
        opacity.setStartValue(this.mOwner.getRipplePaint().getAlpha());
        this.mPendingHwAnimators.add(opacity);
        this.invalidateSelf();
    }

    public final void enter() {
        this.mEnterStartedAtMillis = AnimationUtils.currentAnimationTimeMillis();
        this.startSoftwareEnter();
        this.startHardwareEnter();
    }

    public final void exit() {
        this.startSoftwareExit();
        this.startHardwareExit();
    }

    private float getCurrentX() {
        return MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mTargetX, this.mTweenX);
    }

    private float getCurrentY() {
        return MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mTargetY, this.mTweenY);
    }

    private float getCurrentRadius() {
        return MathUtils.lerp(this.mStartRadius, this.mTargetRadius, this.mTweenRadius);
    }

    public void draw(Canvas c, Paint p) {
        boolean hasDisplayListCanvas = !this.mForceSoftware && c instanceof RecordingCanvas;
        this.pruneSwFinished();
        if (hasDisplayListCanvas) {
            RecordingCanvas hw = (RecordingCanvas)c;
            this.drawHardware(hw, p);
        } else {
            this.drawSoftware(c, p);
        }
    }

    private void clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mTargetRadius - this.mStartRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    public void end() {
        int i;
        for (i = 0; i < this.mRunningSwAnimators.size(); ++i) {
            this.mRunningSwAnimators.get(i).end();
        }
        this.mRunningSwAnimators.clear();
        for (i = 0; i < this.mRunningHwAnimators.size(); ++i) {
            this.mRunningHwAnimators.get(i).end();
        }
        this.mRunningHwAnimators.clear();
    }

    private void onAnimationPropertyChanged() {
        if (!this.mUsingProperties) {
            this.invalidateSelf();
        }
    }

    private void clearHwProps() {
        this.mPropPaint = null;
        this.mPropRadius = null;
        this.mPropX = null;
        this.mPropY = null;
        this.mUsingProperties = false;
    }

    private void switchToUiThreadAnimation() {
        for (int i = 0; i < this.mRunningHwAnimators.size(); ++i) {
            Animator animator2 = this.mRunningHwAnimators.get(i);
            animator2.removeListener(this.mAnimationListener);
            animator2.end();
        }
        this.mRunningHwAnimators.clear();
        this.clearHwProps();
        this.invalidateSelf();
    }
}

