/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScaleDrawable
extends DrawableWrapper {
    private static final int MAX_LEVEL = 10000;
    private final Rect mTmpRect = new Rect();
    @UnsupportedAppUsage
    private ScaleState mState;

    ScaleDrawable() {
        this(new ScaleState(null, null), null);
    }

    public ScaleDrawable(Drawable drawable2, int gravity, float scaleWidth, float scaleHeight) {
        this(new ScaleState(null, null), null);
        this.mState.mGravity = gravity;
        this.mState.mScaleWidth = scaleWidth;
        this.mState.mScaleHeight = scaleHeight;
        this.setDrawable(drawable2);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = ScaleDrawable.obtainAttributes(r, theme, attrs, R.styleable.ScaleDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ScaleState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ScaleDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                ScaleDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        this.updateLocalState();
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <scale> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private void updateStateFromTypedArray(TypedArray a) {
        ScaleState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        ScaleState.access$002(state, a.extractThemeAttrs());
        state.mScaleWidth = ScaleDrawable.getPercent(a, 1, state.mScaleWidth);
        state.mScaleHeight = ScaleDrawable.getPercent(a, 2, state.mScaleHeight);
        state.mGravity = a.getInt(3, state.mGravity);
        state.mUseIntrinsicSizeAsMin = a.getBoolean(4, state.mUseIntrinsicSizeAsMin);
        state.mInitialLevel = a.getInt(5, state.mInitialLevel);
    }

    private static float getPercent(TypedArray a, int index, float defaultValue) {
        int type = a.getType(index);
        if (type == 6 || type == 0) {
            return a.getFraction(index, 1, 1, defaultValue);
        }
        String s = a.getString(index);
        if (s != null && s.endsWith("%")) {
            String f = s.substring(0, s.length() - 1);
            return Float.parseFloat(f) / 100.0f;
        }
        return defaultValue;
    }

    @Override
    public void draw(Canvas canvas) {
        Drawable d = this.getDrawable();
        if (d != null && d.getLevel() != 0) {
            d.draw(canvas);
        }
    }

    @Override
    public int getOpacity() {
        Drawable d = this.getDrawable();
        if (d.getLevel() == 0) {
            return -2;
        }
        int opacity = d.getOpacity();
        if (opacity == -1 && d.getLevel() < 10000) {
            return -3;
        }
        return opacity;
    }

    @Override
    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
        return true;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Drawable d = this.getDrawable();
        Rect r = this.mTmpRect;
        boolean min = this.mState.mUseIntrinsicSizeAsMin;
        int level = this.getLevel();
        int w = bounds.width();
        if (this.mState.mScaleWidth > 0.0f) {
            int iw = min ? d.getIntrinsicWidth() : 0;
            w -= (int)((float)((w - iw) * (10000 - level)) * this.mState.mScaleWidth / 10000.0f);
        }
        int h = bounds.height();
        if (this.mState.mScaleHeight > 0.0f) {
            int ih = min ? d.getIntrinsicHeight() : 0;
            h -= (int)((float)((h - ih) * (10000 - level)) * this.mState.mScaleHeight / 10000.0f);
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            d.setBounds(r.left, r.top, r.right, r.bottom);
        }
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new ScaleState(this.mState, null);
        return this.mState;
    }

    private ScaleDrawable(ScaleState state, Resources res) {
        super(state, res);
        this.mState = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
        this.setLevel(this.mState.mInitialLevel);
    }

    static final class ScaleState
    extends DrawableWrapper.DrawableWrapperState {
        private static final float DO_NOT_SCALE = -1.0f;
        private int[] mThemeAttrs;
        float mScaleWidth = -1.0f;
        float mScaleHeight = -1.0f;
        int mGravity = 3;
        boolean mUseIntrinsicSizeAsMin = false;
        int mInitialLevel = 0;

        ScaleState(ScaleState orig, Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mScaleWidth = orig.mScaleWidth;
                this.mScaleHeight = orig.mScaleHeight;
                this.mGravity = orig.mGravity;
                this.mUseIntrinsicSizeAsMin = orig.mUseIntrinsicSizeAsMin;
                this.mInitialLevel = orig.mInitialLevel;
            }
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new ScaleDrawable(this, res);
        }

        static /* synthetic */ int[] access$002(ScaleState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }
    }
}

