/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import java.util.Objects;

public abstract class Shape
implements Cloneable {
    private float mWidth;
    private float mHeight;

    public final float getWidth() {
        return this.mWidth;
    }

    public final float getHeight() {
        return this.mHeight;
    }

    public abstract void draw(Canvas var1, Paint var2);

    public final void resize(float width, float height) {
        if (width < 0.0f) {
            width = 0.0f;
        }
        if (height < 0.0f) {
            height = 0.0f;
        }
        if (this.mWidth != width || this.mHeight != height) {
            this.mWidth = width;
            this.mHeight = height;
            this.onResize(width, height);
        }
    }

    public boolean hasAlpha() {
        return true;
    }

    protected void onResize(float width, float height) {
    }

    public void getOutline(Outline outline) {
    }

    public Shape clone() throws CloneNotSupportedException {
        return (Shape)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shape shape = (Shape)o;
        return Float.compare(shape.mWidth, this.mWidth) == 0 && Float.compare(shape.mHeight, this.mHeight) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mWidth), Float.valueOf(this.mHeight));
    }
}

