/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.Font;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.CriticalNative;
import java.util.ArrayList;
import java.util.HashSet;
import libcore.util.NativeAllocationRegistry;

public final class FontFamily {
    private static final String TAG = "FontFamily";
    private final ArrayList<Font> mFonts;
    private final long mNativePtr;

    private FontFamily(ArrayList<Font> fonts, long ptr) {
        this.mFonts = fonts;
        this.mNativePtr = ptr;
    }

    public Font getFont(int index) {
        return this.mFonts.get(index);
    }

    public int getSize() {
        return this.mFonts.size();
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public static final class Builder {
        private static final NativeAllocationRegistry sFamilyRegistory = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), Builder.nGetReleaseNativeFamily());
        private final ArrayList<Font> mFonts = new ArrayList();
        private final HashSet<Integer> mStyleHashSet = new HashSet();

        public Builder(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            this.mStyleHashSet.add(Builder.makeStyleIdentifier(font));
            this.mFonts.add(font);
        }

        public Builder addFont(Font font) {
            Preconditions.checkNotNull(font, "font can not be null");
            if (!this.mStyleHashSet.add(Builder.makeStyleIdentifier(font))) {
                throw new IllegalArgumentException(font + " has already been added");
            }
            this.mFonts.add(font);
            return this;
        }

        public FontFamily build() {
            return this.build("", 0, true);
        }

        public FontFamily build(String langTags, int variant, boolean isCustomFallback) {
            long builderPtr = Builder.nInitBuilder();
            for (int i = 0; i < this.mFonts.size(); ++i) {
                Builder.nAddFont(builderPtr, this.mFonts.get(i).getNativePtr());
            }
            long ptr = Builder.nBuild(builderPtr, langTags, variant, isCustomFallback);
            FontFamily family = new FontFamily(this.mFonts, ptr);
            sFamilyRegistory.registerNativeAllocation(family, ptr);
            return family;
        }

        private static int makeStyleIdentifier(Font font) {
            return font.getStyle().getWeight() | font.getStyle().getSlant() << 16;
        }

        private static native long nInitBuilder();

        @CriticalNative
        private static native void nAddFont(long var0, long var2);

        private static native long nBuild(long var0, String var2, int var3, boolean var4);

        @CriticalNative
        private static native long nGetReleaseNativeFamily();
    }
}

