/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.FontVariationAxis;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FontFileUtil {
    private static final int SFNT_VERSION_1 = 65536;
    private static final int SFNT_VERSION_OTTO = 0x4F54544F;
    private static final int TTC_TAG = 1953784678;
    private static final int OS2_TABLE_TAG = 1330851634;
    private static final int ANALYZE_ERROR = -1;

    private FontFileUtil() {
    }

    public static int unpackWeight(int packed) {
        return packed & 0xFFFF;
    }

    public static boolean unpackItalic(int packed) {
        return (packed & 0x10000) != 0;
    }

    public static boolean isSuccess(int packed) {
        return packed != -1;
    }

    private static int pack(int weight, boolean italic) {
        return weight | (italic ? 65536 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int analyzeStyle(ByteBuffer buffer, int ttcIndex, FontVariationAxis[] varSettings) {
        int weight = -1;
        int italic = -1;
        if (varSettings != null) {
            for (FontVariationAxis axis : varSettings) {
                if ("wght".equals(axis.getTag())) {
                    weight = (int)axis.getStyleValue();
                    continue;
                }
                if (!"ital".equals(axis.getTag())) continue;
                italic = axis.getStyleValue() == 1.0f ? 1 : 0;
            }
        }
        if (weight != -1 && italic != -1) {
            return FontFileUtil.pack(weight, italic == 1);
        }
        ByteOrder originalOrder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            int i;
            int sfntVersion;
            int fontFileOffset = 0;
            int magicNumber = buffer.getInt(0);
            if (magicNumber == 1953784678) {
                if (ttcIndex >= buffer.getInt(8)) {
                    int axis = -1;
                    return axis;
                }
                fontFileOffset = buffer.getInt(12 + 4 * ttcIndex);
            }
            if ((sfntVersion = buffer.getInt(fontFileOffset)) != 65536 && sfntVersion != 0x4F54544F) {
                int n = -1;
                return n;
            }
            int numTables = buffer.getShort(fontFileOffset + 4);
            int os2TableOffset = -1;
            for (i = 0; i < numTables; ++i) {
                int tableOffset = fontFileOffset + 12 + i * 16;
                if (buffer.getInt(tableOffset) != 1330851634) continue;
                os2TableOffset = buffer.getInt(tableOffset + 8);
                break;
            }
            if (os2TableOffset == -1) {
                i = FontFileUtil.pack(400, false);
                return i;
            }
            int weightFromOS2 = buffer.getShort(os2TableOffset + 4);
            boolean italicFromOS2 = (buffer.getShort(os2TableOffset + 62) & 1) != 0;
            int n = FontFileUtil.pack(weight == -1 ? weightFromOS2 : weight, italic == -1 ? italicFromOS2 : italic == 1);
            return n;
        }
        finally {
            buffer.order(originalOrder);
        }
    }
}

