/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontListParser;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontCustomizationParser;
import android.graphics.fonts.FontFamily;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class SystemFonts {
    private static final String TAG = "SystemFonts";
    private static final String DEFAULT_FAMILY = "sans-serif";
    private static final Map<String, FontFamily[]> sSystemFallbackMap;
    private static final FontConfig.Alias[] sAliases;
    private static final List<Font> sAvailableFonts;

    private SystemFonts() {
    }

    public static Set<Font> getAvailableFonts() {
        HashSet<Font> set = new HashSet<Font>();
        set.addAll(sAvailableFonts);
        return set;
    }

    public static FontFamily[] getSystemFallback(String familyName) {
        FontFamily[] families = sSystemFallbackMap.get(familyName);
        return families == null ? sSystemFallbackMap.get(DEFAULT_FAMILY) : families;
    }

    public static Map<String, FontFamily[]> getRawSystemFallbackMap() {
        return sSystemFallbackMap;
    }

    public static FontConfig.Alias[] getAliases() {
        return sAliases;
    }

    private static ByteBuffer mmap(String fullPath) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream file = new FileInputStream(fullPath);
        Throwable throwable = null;
        try {
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    SystemFonts.$closeResource(throwable, file);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Error mapping font file " + fullPath);
                return null;
            }
        }
        SystemFonts.$closeResource(throwable, file);
        return mappedByteBuffer;
    }

    private static void pushFamilyToFallback(FontConfig.Family xmlFamily, ArrayMap<String, ArrayList<FontFamily>> fallbackMap, Map<String, ByteBuffer> cache, ArrayList<Font> availableFonts) {
        String languageTags = xmlFamily.getLanguages();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList<FontConfig.Font>> specificFallbackFonts = new ArrayMap<String, ArrayList<FontConfig.Font>>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFallbackFor();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            ArrayList<FontConfig.Font> fallback = (ArrayList<FontConfig.Font>)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList<FontConfig.Font>();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : SystemFonts.createFontFamily(xmlFamily.getName(), defaultFonts, languageTags, variant, cache, availableFonts);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            ArrayList fallback = (ArrayList)specificFallbackFonts.get(fallbackMap.keyAt(i));
            if (fallback == null) {
                if (defaultFamily == null) continue;
                fallbackMap.valueAt(i).add(defaultFamily);
                continue;
            }
            FontFamily family = SystemFonts.createFontFamily(xmlFamily.getName(), fallback, languageTags, variant, cache, availableFonts);
            if (family != null) {
                fallbackMap.valueAt(i).add(family);
                continue;
            }
            if (defaultFamily == null) continue;
            fallbackMap.valueAt(i).add(defaultFamily);
        }
    }

    private static FontFamily createFontFamily(String familyName, List<FontConfig.Font> fonts, String languageTags, int variant, Map<String, ByteBuffer> cache, ArrayList<Font> availableFonts) {
        if (fonts.size() == 0) {
            return null;
        }
        FontFamily.Builder b = null;
        for (int i = 0; i < fonts.size(); ++i) {
            Font font;
            FontConfig.Font fontConfig = fonts.get(i);
            String fullPath = fontConfig.getFontName();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = SystemFonts.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            try {
                font = new Font.Builder(buffer, new File(fullPath), languageTags).setWeight(fontConfig.getWeight()).setSlant(fontConfig.isItalic() ? 1 : 0).setTtcIndex(fontConfig.getTtcIndex()).setFontVariationSettings(fontConfig.getAxes()).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            availableFonts.add(font);
            if (b == null) {
                b = new FontFamily.Builder(font);
                continue;
            }
            b.addFont(font);
        }
        return b == null ? null : b.build(languageTags, variant, false);
    }

    private static void appendNamedFamily(FontConfig.Family xmlFamily, HashMap<String, ByteBuffer> bufferCache, ArrayMap<String, ArrayList<FontFamily>> fallbackListMap, ArrayList<Font> availableFonts) {
        String familyName = xmlFamily.getName();
        FontFamily family = SystemFonts.createFontFamily(familyName, Arrays.asList(xmlFamily.getFonts()), xmlFamily.getLanguages(), xmlFamily.getVariant(), bufferCache, availableFonts);
        if (family == null) {
            return;
        }
        ArrayList<FontFamily> fallback = new ArrayList<FontFamily>();
        fallback.add(family);
        fallbackListMap.put(familyName, fallback);
    }

    @VisibleForTesting
    public static FontConfig.Alias[] buildSystemFallback(String xmlPath, String fontDir, FontCustomizationParser.Result oemCustomization, ArrayMap<String, FontFamily[]> fallbackMap, ArrayList<Font> availableFonts) {
        try {
            int i;
            FileInputStream fontsIn = new FileInputStream(xmlPath);
            FontConfig fontConfig = FontListParser.parse(fontsIn, fontDir);
            HashMap<String, ByteBuffer> bufferCache = new HashMap<String, ByteBuffer>();
            FontConfig.Family[] xmlFamilies = fontConfig.getFamilies();
            ArrayMap<String, ArrayList<FontFamily>> fallbackListMap = new ArrayMap<String, ArrayList<FontFamily>>();
            for (FontConfig.Family xmlFamily : xmlFamilies) {
                String familyName = xmlFamily.getName();
                if (familyName == null) continue;
                SystemFonts.appendNamedFamily(xmlFamily, bufferCache, fallbackListMap, availableFonts);
            }
            for (i = 0; i < oemCustomization.mAdditionalNamedFamilies.size(); ++i) {
                SystemFonts.appendNamedFamily(oemCustomization.mAdditionalNamedFamilies.get(i), bufferCache, fallbackListMap, availableFonts);
            }
            for (i = 0; i < xmlFamilies.length; ++i) {
                FontConfig.Family xmlFamily = xmlFamilies[i];
                if (i != 0 && xmlFamily.getName() != null) continue;
                SystemFonts.pushFamilyToFallback(xmlFamily, fallbackListMap, bufferCache, availableFonts);
            }
            for (i = 0; i < fallbackListMap.size(); ++i) {
                String fallbackName = fallbackListMap.keyAt(i);
                List familyList = fallbackListMap.valueAt(i);
                FontFamily[] families = familyList.toArray(new FontFamily[familyList.size()]);
                fallbackMap.put(fallbackName, families);
            }
            ArrayList<FontConfig.Alias> list = new ArrayList<FontConfig.Alias>();
            list.addAll(Arrays.asList(fontConfig.getAliases()));
            list.addAll(oemCustomization.mAdditionalAliases);
            return list.toArray(new FontConfig.Alias[list.size()]);
        }
        catch (IOException | XmlPullParserException e) {
            Log.e(TAG, "Failed initialize system fallbacks.", e);
            return ArrayUtils.emptyArray(FontConfig.Alias.class);
        }
    }

    private static FontCustomizationParser.Result readFontCustomization(String customizeXml, String customFontsDir) {
        FontCustomizationParser.Result result;
        FileInputStream f = new FileInputStream(customizeXml);
        Throwable throwable = null;
        try {
            result = FontCustomizationParser.parse(f, customFontsDir);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    SystemFonts.$closeResource(throwable, f);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                return new FontCustomizationParser.Result();
            }
            catch (XmlPullParserException e) {
                Log.e(TAG, "Failed to parse font customization XML", e);
                return new FontCustomizationParser.Result();
            }
        }
        SystemFonts.$closeResource(throwable, f);
        return result;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        ArrayMap<String, FontFamily[]> systemFallbackMap = new ArrayMap<String, FontFamily[]>();
        ArrayList<Font> availableFonts = new ArrayList<Font>();
        FontCustomizationParser.Result oemCustomization = SystemFonts.readFontCustomization("/product/etc/fonts_customization.xml", "/product/fonts/");
        sAliases = SystemFonts.buildSystemFallback("/system/etc/fonts.xml", "/system/fonts/", oemCustomization, systemFallbackMap, availableFonts);
        sSystemFallbackMap = Collections.unmodifiableMap(systemFallbackMap);
        sAvailableFonts = Collections.unmodifiableList(availableFonts);
    }
}

