/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.ISensorPrivacyListener;
import android.hardware.ISensorPrivacyManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;

public final class SensorPrivacyManager {
    private static final Object sInstanceLock = new Object();
    @GuardedBy(value={"sInstanceLock"})
    private static SensorPrivacyManager sInstance;
    private final Context mContext;
    private final ISensorPrivacyManager mService;
    private final ArrayMap<OnSensorPrivacyChangedListener, ISensorPrivacyListener> mListeners;

    private SensorPrivacyManager(Context context, ISensorPrivacyManager service) {
        this.mContext = context;
        this.mService = service;
        this.mListeners = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SensorPrivacyManager getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                try {
                    IBinder b = ServiceManager.getServiceOrThrow("sensor_privacy");
                    ISensorPrivacyManager service = ISensorPrivacyManager.Stub.asInterface(b);
                    sInstance = new SensorPrivacyManager(context, service);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            return sInstance;
        }
    }

    public void setSensorPrivacy(boolean enable) {
        try {
            this.mService.setSensorPrivacy(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSensorPrivacyListener(final OnSensorPrivacyChangedListener listener) {
        ArrayMap<OnSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener);
            if (iListener == null) {
                iListener = new ISensorPrivacyListener.Stub(){

                    @Override
                    public void onSensorPrivacyChanged(boolean enabled) {
                        listener.onSensorPrivacyChanged(enabled);
                    }
                };
                this.mListeners.put(listener, iListener);
            }
            try {
                this.mService.addSensorPrivacyListener(iListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensorPrivacyListener(OnSensorPrivacyChangedListener listener) {
        ArrayMap<OnSensorPrivacyChangedListener, ISensorPrivacyListener> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            ISensorPrivacyListener iListener = this.mListeners.get(listener);
            if (iListener != null) {
                this.mListeners.remove(iListener);
                try {
                    this.mService.removeSensorPrivacyListener(iListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    public boolean isSensorPrivacyEnabled() {
        try {
            return this.mService.isSensorPrivacyEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface OnSensorPrivacyChangedListener {
        public void onSensorPrivacyChanged(boolean var1);
    }
}

