/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.UnsupportedAppUsage;
import android.os.ParcelFileDescriptor;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SerialPort {
    private static final String TAG = "SerialPort";
    @UnsupportedAppUsage
    private int mNativeContext;
    private final String mName;
    private ParcelFileDescriptor mFileDescriptor;

    public SerialPort(String name) {
        this.mName = name;
    }

    public void open(ParcelFileDescriptor pfd, int speed) throws IOException {
        this.native_open(pfd.getFileDescriptor(), speed);
        this.mFileDescriptor = pfd;
    }

    @UnsupportedAppUsage
    public void close() throws IOException {
        if (this.mFileDescriptor != null) {
            this.mFileDescriptor.close();
            this.mFileDescriptor = null;
        }
        this.native_close();
    }

    public String getName() {
        return this.mName;
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (buffer.isDirect()) {
            return this.native_read_direct(buffer, buffer.remaining());
        }
        if (buffer.hasArray()) {
            return this.native_read_array(buffer.array(), buffer.remaining());
        }
        throw new IllegalArgumentException("buffer is not direct and has no array");
    }

    @UnsupportedAppUsage
    public void write(ByteBuffer buffer, int length) throws IOException {
        if (buffer.isDirect()) {
            this.native_write_direct(buffer, length);
        } else if (buffer.hasArray()) {
            this.native_write_array(buffer.array(), length);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
    }

    public void sendBreak() {
        this.native_send_break();
    }

    private native void native_open(FileDescriptor var1, int var2) throws IOException;

    private native void native_close();

    private native int native_read_array(byte[] var1, int var2) throws IOException;

    private native int native_read_direct(ByteBuffer var1, int var2) throws IOException;

    private native void native_write_array(byte[] var1, int var2) throws IOException;

    private native void native_write_direct(ByteBuffer var1, int var2) throws IOException;

    private native void native_send_break();
}

