/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.content.Context;
import android.content.DialogInterface;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricConstants;
import android.hardware.biometrics.BiometricManager;
import android.hardware.biometrics.IBiometricConfirmDeviceCredentialCallback;
import android.hardware.biometrics.IBiometricService;
import android.hardware.biometrics.IBiometricServiceReceiver;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import java.security.Signature;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.Mac;

public class BiometricPrompt
implements BiometricAuthenticator,
BiometricConstants {
    private static final String TAG = "BiometricPrompt";
    public static final String KEY_TITLE = "title";
    public static final String KEY_USE_DEFAULT_TITLE = "use_default_title";
    public static final String KEY_SUBTITLE = "subtitle";
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_POSITIVE_TEXT = "positive_text";
    public static final String KEY_NEGATIVE_TEXT = "negative_text";
    public static final String KEY_REQUIRE_CONFIRMATION = "require_confirmation";
    public static final String KEY_ALLOW_DEVICE_CREDENTIAL = "allow_device_credential";
    public static final String KEY_FROM_CONFIRM_DEVICE_CREDENTIAL = "from_confirm_device_credential";
    public static final int HIDE_DIALOG_DELAY = 2000;
    public static final int DISMISSED_REASON_POSITIVE = 1;
    public static final int DISMISSED_REASON_NEGATIVE = 2;
    public static final int DISMISSED_REASON_USER_CANCEL = 3;
    private final IBinder mToken = new Binder();
    private final Context mContext;
    private final IBiometricService mService;
    private final Bundle mBundle;
    private final ButtonInfo mPositiveButtonInfo;
    private final ButtonInfo mNegativeButtonInfo;
    private CryptoObject mCryptoObject;
    private Executor mExecutor;
    private AuthenticationCallback mAuthenticationCallback;
    private final IBiometricServiceReceiver mBiometricServiceReceiver = new IBiometricServiceReceiver.Stub(){

        @Override
        public void onAuthenticationSucceeded() throws RemoteException {
            BiometricPrompt.this.mExecutor.execute(() -> {
                AuthenticationResult result = new AuthenticationResult(BiometricPrompt.this.mCryptoObject);
                BiometricPrompt.this.mAuthenticationCallback.onAuthenticationSucceeded(result);
            });
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
            BiometricPrompt.this.mExecutor.execute(() -> BiometricPrompt.this.mAuthenticationCallback.onAuthenticationFailed());
        }

        @Override
        public void onError(int error, String message) throws RemoteException {
            BiometricPrompt.this.mExecutor.execute(() -> BiometricPrompt.this.mAuthenticationCallback.onAuthenticationError(error, message));
        }

        @Override
        public void onAcquired(int acquireInfo, String message) throws RemoteException {
            BiometricPrompt.this.mExecutor.execute(() -> BiometricPrompt.this.mAuthenticationCallback.onAuthenticationHelp(acquireInfo, message));
        }

        @Override
        public void onDialogDismissed(int reason) throws RemoteException {
            if (reason == 1) {
                ((BiometricPrompt)BiometricPrompt.this).mPositiveButtonInfo.executor.execute(() -> ((BiometricPrompt)BiometricPrompt.this).mPositiveButtonInfo.listener.onClick(null, -1));
            } else if (reason == 2) {
                ((BiometricPrompt)BiometricPrompt.this).mNegativeButtonInfo.executor.execute(() -> ((BiometricPrompt)BiometricPrompt.this).mNegativeButtonInfo.listener.onClick(null, -2));
            }
        }
    };

    private BiometricPrompt(Context context, Bundle bundle, ButtonInfo positiveButtonInfo, ButtonInfo negativeButtonInfo) {
        this.mContext = context;
        this.mBundle = bundle;
        this.mPositiveButtonInfo = positiveButtonInfo;
        this.mNegativeButtonInfo = negativeButtonInfo;
        this.mService = IBiometricService.Stub.asInterface(ServiceManager.getService("biometric"));
    }

    public void authenticateUser(CancellationSignal cancel, Executor executor, AuthenticationCallback callback, int userId, IBiometricConfirmDeviceCredentialCallback confirmDeviceCredentialCallback) {
        if (cancel == null) {
            throw new IllegalArgumentException("Must supply a cancellation signal");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must supply an executor");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply a callback");
        }
        this.authenticateInternal(null, cancel, executor, callback, userId, confirmDeviceCredentialCallback);
    }

    public void authenticate(CryptoObject crypto, CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (crypto == null) {
            throw new IllegalArgumentException("Must supply a crypto object");
        }
        if (cancel == null) {
            throw new IllegalArgumentException("Must supply a cancellation signal");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must supply an executor");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply a callback");
        }
        if (this.mBundle.getBoolean(KEY_ALLOW_DEVICE_CREDENTIAL)) {
            throw new IllegalArgumentException("Device credential not supported with crypto");
        }
        this.authenticateInternal(crypto, cancel, executor, callback, this.mContext.getUserId(), null);
    }

    public void authenticate(CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (cancel == null) {
            throw new IllegalArgumentException("Must supply a cancellation signal");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must supply an executor");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply a callback");
        }
        this.authenticateInternal(null, cancel, executor, callback, this.mContext.getUserId(), null);
    }

    private void cancelAuthentication() {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to cancel authentication", e);
            }
        }
    }

    private void authenticateInternal(CryptoObject crypto, CancellationSignal cancel, Executor executor, AuthenticationCallback callback, int userId, IBiometricConfirmDeviceCredentialCallback confirmDeviceCredentialCallback) {
        try {
            long sessionId;
            if (cancel.isCanceled()) {
                Log.w(TAG, "Authentication already canceled");
                return;
            }
            cancel.setOnCancelListener(new OnAuthenticationCancelListener());
            this.mCryptoObject = crypto;
            this.mExecutor = executor;
            this.mAuthenticationCallback = callback;
            long l = sessionId = crypto != null ? crypto.getOpId() : 0L;
            if (BiometricManager.hasBiometrics(this.mContext)) {
                this.mService.authenticate(this.mToken, sessionId, userId, this.mBiometricServiceReceiver, this.mContext.getOpPackageName(), this.mBundle, confirmDeviceCredentialCallback);
            } else {
                this.mExecutor.execute(() -> callback.onAuthenticationError(12, this.mContext.getString(17039612)));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Remote exception while authenticating", e);
            this.mExecutor.execute(() -> callback.onAuthenticationError(1, this.mContext.getString(17039612)));
        }
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }
    }

    public static class AuthenticationResult
    extends BiometricAuthenticator.AuthenticationResult {
        public AuthenticationResult(CryptoObject crypto) {
            super(crypto, null, 0);
        }

        @Override
        public CryptoObject getCryptoObject() {
            return (CryptoObject)super.getCryptoObject();
        }
    }

    public static final class CryptoObject
    extends android.hardware.biometrics.CryptoObject {
        public CryptoObject(Signature signature) {
            super(signature);
        }

        public CryptoObject(Cipher cipher) {
            super(cipher);
        }

        public CryptoObject(Mac mac) {
            super(mac);
        }

        @Override
        public Signature getSignature() {
            return super.getSignature();
        }

        @Override
        public Cipher getCipher() {
            return super.getCipher();
        }

        @Override
        public Mac getMac() {
            return super.getMac();
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private OnAuthenticationCancelListener() {
        }

        @Override
        public void onCancel() {
            BiometricPrompt.this.cancelAuthentication();
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private ButtonInfo mPositiveButtonInfo;
        private ButtonInfo mNegativeButtonInfo;
        private Context mContext;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setTitle(CharSequence title) {
            this.mBundle.putCharSequence(BiometricPrompt.KEY_TITLE, title);
            return this;
        }

        public Builder setUseDefaultTitle() {
            this.mBundle.putBoolean(BiometricPrompt.KEY_USE_DEFAULT_TITLE, true);
            return this;
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.mBundle.putCharSequence(BiometricPrompt.KEY_SUBTITLE, subtitle);
            return this;
        }

        public Builder setDescription(CharSequence description) {
            this.mBundle.putCharSequence(BiometricPrompt.KEY_DESCRIPTION, description);
            return this;
        }

        public Builder setPositiveButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.mBundle.putCharSequence(BiometricPrompt.KEY_POSITIVE_TEXT, text);
            this.mPositiveButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        public Builder setNegativeButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.mBundle.putCharSequence(BiometricPrompt.KEY_NEGATIVE_TEXT, text);
            this.mNegativeButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        public Builder setConfirmationRequired(boolean requireConfirmation) {
            this.mBundle.putBoolean(BiometricPrompt.KEY_REQUIRE_CONFIRMATION, requireConfirmation);
            return this;
        }

        public Builder setDeviceCredentialAllowed(boolean allowed) {
            this.mBundle.putBoolean(BiometricPrompt.KEY_ALLOW_DEVICE_CREDENTIAL, allowed);
            return this;
        }

        public Builder setFromConfirmDeviceCredential() {
            this.mBundle.putBoolean(BiometricPrompt.KEY_FROM_CONFIRM_DEVICE_CREDENTIAL, true);
            return this;
        }

        public BiometricPrompt build() {
            CharSequence title = this.mBundle.getCharSequence(BiometricPrompt.KEY_TITLE);
            CharSequence negative = this.mBundle.getCharSequence(BiometricPrompt.KEY_NEGATIVE_TEXT);
            boolean useDefaultTitle = this.mBundle.getBoolean(BiometricPrompt.KEY_USE_DEFAULT_TITLE);
            boolean enableFallback = this.mBundle.getBoolean(BiometricPrompt.KEY_ALLOW_DEVICE_CREDENTIAL);
            if (TextUtils.isEmpty(title) && !useDefaultTitle) {
                throw new IllegalArgumentException("Title must be set and non-empty");
            }
            if (TextUtils.isEmpty(negative) && !enableFallback) {
                throw new IllegalArgumentException("Negative text must be set and non-empty");
            }
            if (!TextUtils.isEmpty(negative) && enableFallback) {
                throw new IllegalArgumentException("Can't have both negative button behavior and device credential enabled");
            }
            return new BiometricPrompt(this.mContext, this.mBundle, this.mPositiveButtonInfo, this.mNegativeButtonInfo);
        }
    }

    private static class ButtonInfo {
        Executor executor;
        DialogInterface.OnClickListener listener;

        ButtonInfo(Executor ex, DialogInterface.OnClickListener l) {
            this.executor = ex;
            this.listener = l;
        }
    }
}

