/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.broadcastradio.V2_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class Metadata {
    public int key;
    public long intValue;
    public String stringValue = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != Metadata.class) {
            return false;
        }
        Metadata other = (Metadata)otherObject;
        if (this.key != other.key) {
            return false;
        }
        if (this.intValue != other.intValue) {
            return false;
        }
        return HidlSupport.deepEquals(this.stringValue, other.stringValue);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.key), HidlSupport.deepHashCode(this.intValue), HidlSupport.deepHashCode(this.stringValue));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".key = ");
        builder.append(this.key);
        builder.append(", .intValue = ");
        builder.append(this.intValue);
        builder.append(", .stringValue = ");
        builder.append(this.stringValue);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(32L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<Metadata> readVectorFromParcel(HwParcel parcel) {
        ArrayList<Metadata> _hidl_vec = new ArrayList<Metadata>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            Metadata _hidl_vec_element = new Metadata();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.key = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.intValue = _hidl_blob.getInt64(_hidl_offset + 8L);
        this.stringValue = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.stringValue.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(32);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<Metadata> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.key);
        _hidl_blob.putInt64(_hidl_offset + 8L, this.intValue);
        _hidl_blob.putString(_hidl_offset + 16L, this.stringValue);
    }
}

