/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.broadcastradio.V2_0;

import android.hardware.broadcastradio.V2_0.Metadata;
import android.hardware.broadcastradio.V2_0.ProgramIdentifier;
import android.hardware.broadcastradio.V2_0.ProgramInfoFlags;
import android.hardware.broadcastradio.V2_0.ProgramSelector;
import android.hardware.broadcastradio.V2_0.VendorKeyValue;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class ProgramInfo {
    public ProgramSelector selector = new ProgramSelector();
    public ProgramIdentifier logicallyTunedTo = new ProgramIdentifier();
    public ProgramIdentifier physicallyTunedTo = new ProgramIdentifier();
    public ArrayList<ProgramIdentifier> relatedContent = new ArrayList();
    public int infoFlags;
    public int signalQuality;
    public ArrayList<Metadata> metadata = new ArrayList();
    public ArrayList<VendorKeyValue> vendorInfo = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ProgramInfo.class) {
            return false;
        }
        ProgramInfo other = (ProgramInfo)otherObject;
        if (!HidlSupport.deepEquals(this.selector, other.selector)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.logicallyTunedTo, other.logicallyTunedTo)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.physicallyTunedTo, other.physicallyTunedTo)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.relatedContent, other.relatedContent)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.infoFlags, other.infoFlags)) {
            return false;
        }
        if (this.signalQuality != other.signalQuality) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.metadata, other.metadata)) {
            return false;
        }
        return HidlSupport.deepEquals(this.vendorInfo, other.vendorInfo);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.selector), HidlSupport.deepHashCode(this.logicallyTunedTo), HidlSupport.deepHashCode(this.physicallyTunedTo), HidlSupport.deepHashCode(this.relatedContent), HidlSupport.deepHashCode(this.infoFlags), HidlSupport.deepHashCode(this.signalQuality), HidlSupport.deepHashCode(this.metadata), HidlSupport.deepHashCode(this.vendorInfo));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".selector = ");
        builder.append(this.selector);
        builder.append(", .logicallyTunedTo = ");
        builder.append(this.logicallyTunedTo);
        builder.append(", .physicallyTunedTo = ");
        builder.append(this.physicallyTunedTo);
        builder.append(", .relatedContent = ");
        builder.append(this.relatedContent);
        builder.append(", .infoFlags = ");
        builder.append(ProgramInfoFlags.dumpBitfield(this.infoFlags));
        builder.append(", .signalQuality = ");
        builder.append(this.signalQuality);
        builder.append(", .metadata = ");
        builder.append(this.metadata);
        builder.append(", .vendorInfo = ");
        builder.append(this.vendorInfo);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(120L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<ProgramInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ProgramInfo> _hidl_vec = new ArrayList<ProgramInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 120, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ProgramInfo _hidl_vec_element = new ProgramInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 120);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.selector.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.logicallyTunedTo.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 32L);
        this.physicallyTunedTo.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 48L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 64L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), _hidl_offset + 64L + 0L, true);
        this.relatedContent.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new ProgramIdentifier();
            ((ProgramIdentifier)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            this.relatedContent.add((ProgramIdentifier)_hidl_vec_element);
        }
        this.infoFlags = _hidl_blob.getInt32(_hidl_offset + 80L);
        this.signalQuality = _hidl_blob.getInt32(_hidl_offset + 84L);
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 88L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), _hidl_offset + 88L + 0L, true);
        this.metadata.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new Metadata();
            ((Metadata)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            this.metadata.add((Metadata)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 104L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), _hidl_offset + 104L + 0L, true);
        this.vendorInfo.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new VendorKeyValue();
            ((VendorKeyValue)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            this.vendorInfo.add((VendorKeyValue)_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(120);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<ProgramInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 120);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 120);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        this.selector.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.logicallyTunedTo.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 32L);
        this.physicallyTunedTo.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 48L);
        int _hidl_vec_size = this.relatedContent.size();
        _hidl_blob.putInt32(_hidl_offset + 64L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 64L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.relatedContent.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(_hidl_offset + 64L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 80L, this.infoFlags);
        _hidl_blob.putInt32(_hidl_offset + 84L, this.signalQuality);
        _hidl_vec_size = this.metadata.size();
        _hidl_blob.putInt32(_hidl_offset + 88L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 88L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 32);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.metadata.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(_hidl_offset + 88L + 0L, childBlob);
        _hidl_vec_size = this.vendorInfo.size();
        _hidl_blob.putInt32(_hidl_offset + 104L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 104L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 32);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.vendorInfo.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(_hidl_offset + 104L + 0L, childBlob);
    }
}

