/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.os.Binder;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;

public class CallbackProxies {
    private CallbackProxies() {
        throw new AssertionError();
    }

    public static class SessionStateCallbackProxy
    extends CameraCaptureSession.StateCallback {
        private final Executor mExecutor;
        private final CameraCaptureSession.StateCallback mCallback;

        public SessionStateCallbackProxy(Executor executor, CameraCaptureSession.StateCallback callback) {
            this.mExecutor = Preconditions.checkNotNull(executor, "executor must not be null");
            this.mCallback = Preconditions.checkNotNull(callback, "callback must not be null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigured(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onConfigured(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigureFailed(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onConfigureFailed(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReady(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onReady(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActive(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onActive(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureQueueEmpty(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onCaptureQueueEmpty(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(CameraCaptureSession session) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onClosed(session));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSurfacePrepared(CameraCaptureSession session, Surface surface) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onSurfacePrepared(session, surface));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }
}

