/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class LegacyFocusStateMapper {
    private static String TAG = "LegacyFocusStateMapper";
    private static final boolean DEBUG = false;
    private final Camera mCamera;
    private int mAfStatePrevious = 0;
    private String mAfModePrevious = null;
    private final Object mLock = new Object();
    private int mAfRun = 0;
    private int mAfState = 0;

    public LegacyFocusStateMapper(Camera camera) {
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestTriggers(CaptureRequest captureRequest, Camera.Parameters parameters) {
        int currentAfRun;
        Preconditions.checkNotNull(captureRequest, "captureRequest must not be null");
        int afTrigger = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AF_TRIGGER, 0);
        final String afMode = parameters.getFocusMode();
        if (!Objects.equals(this.mAfModePrevious, afMode)) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mAfRun;
                this.mAfState = 0;
            }
            this.mCamera.cancelAutoFocus();
        }
        this.mAfModePrevious = afMode;
        Object object = this.mLock;
        synchronized (object) {
            currentAfRun = this.mAfRun;
        }
        Object afMoveCallback = new Camera.AutoFocusMoveCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAutoFocusMoving(boolean start, Camera camera) {
                Object object = LegacyFocusStateMapper.this.mLock;
                synchronized (object) {
                    int latestAfRun = LegacyFocusStateMapper.this.mAfRun;
                    if (currentAfRun != latestAfRun) {
                        Log.d(TAG, "onAutoFocusMoving - ignoring move callbacks from old af run" + currentAfRun);
                        return;
                    }
                    int newAfState = start ? 1 : 2;
                    switch (afMode) {
                        case "continuous-picture": 
                        case "continuous-video": {
                            break;
                        }
                        default: {
                            Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + afMode);
                        }
                    }
                    LegacyFocusStateMapper.this.mAfState = newAfState;
                }
            }
        };
        switch (afMode) {
            case "auto": 
            case "macro": 
            case "continuous-picture": 
            case "continuous-video": {
                this.mCamera.setAutoFocusMoveCallback((Camera.AutoFocusMoveCallback)afMoveCallback);
            }
        }
        switch (afTrigger) {
            case 1: {
                int currentAfRun2;
                int afStateAfterStart;
                switch (afMode) {
                    case "auto": 
                    case "macro": {
                        afStateAfterStart = 3;
                        break;
                    }
                    case "continuous-picture": 
                    case "continuous-video": {
                        afStateAfterStart = 1;
                        break;
                    }
                    default: {
                        afStateAfterStart = 0;
                    }
                }
                Object object2 = this.mLock;
                synchronized (object2) {
                    currentAfRun2 = ++this.mAfRun;
                    this.mAfState = afStateAfterStart;
                }
                if (afStateAfterStart == 0) break;
                this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onAutoFocus(boolean success, Camera camera) {
                        Object object = LegacyFocusStateMapper.this.mLock;
                        synchronized (object) {
                            int latestAfRun = LegacyFocusStateMapper.this.mAfRun;
                            if (latestAfRun != currentAfRun2) {
                                Log.d(TAG, String.format("onAutoFocus - ignoring AF callback (old run %d, new run %d)", currentAfRun2, latestAfRun));
                                return;
                            }
                            int newAfState = success ? 4 : 5;
                            switch (afMode) {
                                case "auto": 
                                case "continuous-picture": 
                                case "continuous-video": 
                                case "macro": {
                                    break;
                                }
                                default: {
                                    Log.w(TAG, "onAutoFocus - got unexpected onAutoFocus in mode " + afMode);
                                }
                            }
                            LegacyFocusStateMapper.this.mAfState = newAfState;
                        }
                    }
                });
                break;
            }
            case 2: {
                Object object3 = this.mLock;
                synchronized (object3) {
                    Object object4 = this.mLock;
                    synchronized (object4) {
                        int updatedAfRun = ++this.mAfRun;
                        this.mAfState = 0;
                    }
                    this.mCamera.cancelAutoFocus();
                    break;
                }
            }
            case 0: {
                break;
            }
            default: {
                Log.w(TAG, "processRequestTriggers - ignoring unknown control.afTrigger = " + afTrigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapResultTriggers(CameraMetadataNative result) {
        int newAfState;
        Preconditions.checkNotNull(result, "result must not be null");
        Object object = this.mLock;
        synchronized (object) {
            newAfState = this.mAfState;
        }
        result.set(CaptureResult.CONTROL_AF_STATE, Integer.valueOf(newAfState));
        this.mAfStatePrevious = newAfState;
    }

    private static String afStateToString(int afState) {
        switch (afState) {
            case 3: {
                return "ACTIVE_SCAN";
            }
            case 4: {
                return "FOCUSED_LOCKED";
            }
            case 0: {
                return "INACTIVE";
            }
            case 5: {
                return "NOT_FOCUSED_LOCKED";
            }
            case 2: {
                return "PASSIVE_FOCUSED";
            }
            case 1: {
                return "PASSIVE_SCAN";
            }
            case 6: {
                return "PASSIVE_UNFOCUSED";
            }
        }
        return "UNKNOWN(" + afState + ")";
    }
}

