/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public final class SessionConfiguration
implements Parcelable {
    private static final String TAG = "SessionConfiguration";
    public static final int SESSION_REGULAR = 0;
    public static final int SESSION_HIGH_SPEED = 1;
    public static final int SESSION_VENDOR_START = 32768;
    private List<OutputConfiguration> mOutputConfigurations;
    private CameraCaptureSession.StateCallback mStateCallback;
    private int mSessionType;
    private Executor mExecutor = null;
    private InputConfiguration mInputConfig = null;
    private CaptureRequest mSessionParameters = null;
    public static final Parcelable.Creator<SessionConfiguration> CREATOR = new Parcelable.Creator<SessionConfiguration>(){

        @Override
        public SessionConfiguration createFromParcel(Parcel source) {
            try {
                SessionConfiguration sessionConfiguration = new SessionConfiguration(source);
                return sessionConfiguration;
            }
            catch (Exception e) {
                Log.e(SessionConfiguration.TAG, "Exception creating SessionConfiguration from parcel", e);
                return null;
            }
        }

        public SessionConfiguration[] newArray(int size) {
            return new SessionConfiguration[size];
        }
    };

    public SessionConfiguration(int sessionType, List<OutputConfiguration> outputs, Executor executor, CameraCaptureSession.StateCallback cb) {
        this.mSessionType = sessionType;
        this.mOutputConfigurations = Collections.unmodifiableList(new ArrayList<OutputConfiguration>(outputs));
        this.mStateCallback = cb;
        this.mExecutor = executor;
    }

    private SessionConfiguration(Parcel source) {
        int sessionType = source.readInt();
        int inputWidth = source.readInt();
        int inputHeight = source.readInt();
        int inputFormat = source.readInt();
        ArrayList<OutputConfiguration> outConfigs = new ArrayList<OutputConfiguration>();
        source.readTypedList(outConfigs, OutputConfiguration.CREATOR);
        if (inputWidth > 0 && inputHeight > 0 && inputFormat != -1) {
            this.mInputConfig = new InputConfiguration(inputWidth, inputHeight, inputFormat);
        }
        this.mSessionType = sessionType;
        this.mOutputConfigurations = outConfigs;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mSessionType);
        if (this.mInputConfig != null) {
            dest.writeInt(this.mInputConfig.getWidth());
            dest.writeInt(this.mInputConfig.getHeight());
            dest.writeInt(this.mInputConfig.getFormat());
        } else {
            dest.writeInt(0);
            dest.writeInt(0);
            dest.writeInt(-1);
        }
        dest.writeTypedList(this.mOutputConfigurations);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SessionConfiguration) {
            SessionConfiguration other = (SessionConfiguration)obj;
            if (this.mInputConfig != other.mInputConfig || this.mSessionType != other.mSessionType || this.mOutputConfigurations.size() != other.mOutputConfigurations.size()) {
                return false;
            }
            for (int i = 0; i < this.mOutputConfigurations.size(); ++i) {
                if (this.mOutputConfigurations.get(i).equals(other.mOutputConfigurations.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mOutputConfigurations.hashCode(), this.mInputConfig.hashCode(), this.mSessionType);
    }

    public int getSessionType() {
        return this.mSessionType;
    }

    public List<OutputConfiguration> getOutputConfigurations() {
        return this.mOutputConfigurations;
    }

    public CameraCaptureSession.StateCallback getStateCallback() {
        return this.mStateCallback;
    }

    public Executor getExecutor() {
        return this.mExecutor;
    }

    public void setInputConfiguration(InputConfiguration input) {
        if (this.mSessionType == 1) {
            throw new UnsupportedOperationException("Method not supported for high speed session types");
        }
        this.mInputConfig = input;
    }

    public InputConfiguration getInputConfiguration() {
        return this.mInputConfig;
    }

    public void setSessionParameters(CaptureRequest params) {
        this.mSessionParameters = params;
    }

    public CaptureRequest getSessionParameters() {
        return this.mSessionParameters;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionMode {
    }
}

