/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.hardware.contexthub.V1_0.MemRange;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class HubAppInfo {
    public long appId;
    public int version;
    public ArrayList<MemRange> memUsage = new ArrayList();
    public boolean enabled;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != HubAppInfo.class) {
            return false;
        }
        HubAppInfo other = (HubAppInfo)otherObject;
        if (this.appId != other.appId) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.memUsage, other.memUsage)) {
            return false;
        }
        return this.enabled == other.enabled;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.appId), HidlSupport.deepHashCode(this.version), HidlSupport.deepHashCode(this.memUsage), HidlSupport.deepHashCode(this.enabled));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".appId = ");
        builder.append(this.appId);
        builder.append(", .version = ");
        builder.append(this.version);
        builder.append(", .memUsage = ");
        builder.append(this.memUsage);
        builder.append(", .enabled = ");
        builder.append(this.enabled);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<HubAppInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<HubAppInfo> _hidl_vec = new ArrayList<HubAppInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            HubAppInfo _hidl_vec_element = new HubAppInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.appId = _hidl_blob.getInt64(_hidl_offset + 0L);
        this.version = _hidl_blob.getInt32(_hidl_offset + 8L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 16L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), _hidl_offset + 16L + 0L, true);
        this.memUsage.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            MemRange _hidl_vec_element = new MemRange();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            this.memUsage.add(_hidl_vec_element);
        }
        this.enabled = _hidl_blob.getBool(_hidl_offset + 32L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<HubAppInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt64(_hidl_offset + 0L, this.appId);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.version);
        int _hidl_vec_size = this.memUsage.size();
        _hidl_blob.putInt32(_hidl_offset + 16L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 16L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.memUsage.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(_hidl_offset + 16L + 0L, childBlob);
        _hidl_blob.putBool(_hidl_offset + 32L, this.enabled);
    }
}

