/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.hardware.contexthub.V1_0.NanoAppFlags;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class NanoAppBinary {
    public long appId;
    public int appVersion;
    public int flags;
    public byte targetChreApiMajorVersion;
    public byte targetChreApiMinorVersion;
    public ArrayList<Byte> customBinary = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != NanoAppBinary.class) {
            return false;
        }
        NanoAppBinary other = (NanoAppBinary)otherObject;
        if (this.appId != other.appId) {
            return false;
        }
        if (this.appVersion != other.appVersion) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.flags, other.flags)) {
            return false;
        }
        if (this.targetChreApiMajorVersion != other.targetChreApiMajorVersion) {
            return false;
        }
        if (this.targetChreApiMinorVersion != other.targetChreApiMinorVersion) {
            return false;
        }
        return HidlSupport.deepEquals(this.customBinary, other.customBinary);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.appId), HidlSupport.deepHashCode(this.appVersion), HidlSupport.deepHashCode(this.flags), HidlSupport.deepHashCode(this.targetChreApiMajorVersion), HidlSupport.deepHashCode(this.targetChreApiMinorVersion), HidlSupport.deepHashCode(this.customBinary));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".appId = ");
        builder.append(this.appId);
        builder.append(", .appVersion = ");
        builder.append(this.appVersion);
        builder.append(", .flags = ");
        builder.append(NanoAppFlags.dumpBitfield(this.flags));
        builder.append(", .targetChreApiMajorVersion = ");
        builder.append(this.targetChreApiMajorVersion);
        builder.append(", .targetChreApiMinorVersion = ");
        builder.append(this.targetChreApiMinorVersion);
        builder.append(", .customBinary = ");
        builder.append(this.customBinary);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<NanoAppBinary> readVectorFromParcel(HwParcel parcel) {
        ArrayList<NanoAppBinary> _hidl_vec = new ArrayList<NanoAppBinary>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            NanoAppBinary _hidl_vec_element = new NanoAppBinary();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.appId = _hidl_blob.getInt64(_hidl_offset + 0L);
        this.appVersion = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.flags = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.targetChreApiMajorVersion = _hidl_blob.getInt8(_hidl_offset + 16L);
        this.targetChreApiMinorVersion = _hidl_blob.getInt8(_hidl_offset + 17L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 24L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 24L + 0L, true);
        this.customBinary.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            byte _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.customBinary.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<NanoAppBinary> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt64(_hidl_offset + 0L, this.appId);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.appVersion);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.flags);
        _hidl_blob.putInt8(_hidl_offset + 16L, this.targetChreApiMajorVersion);
        _hidl_blob.putInt8(_hidl_offset + 17L, this.targetChreApiMinorVersion);
        int _hidl_vec_size = this.customBinary.size();
        _hidl_blob.putInt32(_hidl_offset + 24L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 24L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.customBinary.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 24L + 0L, childBlob);
    }
}

