/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub.V1_0;

import android.hardware.contexthub.V1_0.SensorType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class PhysicalSensor {
    public int sensorType;
    public String type = new String();
    public String name = new String();
    public String vendor = new String();
    public int version;
    public int fifoReservedCount;
    public int fifoMaxCount;
    public long minDelayMs;
    public long maxDelayMs;
    public float peakPowerMw;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != PhysicalSensor.class) {
            return false;
        }
        PhysicalSensor other = (PhysicalSensor)otherObject;
        if (this.sensorType != other.sensorType) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.type, other.type)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.name, other.name)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.vendor, other.vendor)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.fifoReservedCount != other.fifoReservedCount) {
            return false;
        }
        if (this.fifoMaxCount != other.fifoMaxCount) {
            return false;
        }
        if (this.minDelayMs != other.minDelayMs) {
            return false;
        }
        if (this.maxDelayMs != other.maxDelayMs) {
            return false;
        }
        return this.peakPowerMw == other.peakPowerMw;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.sensorType), HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.name), HidlSupport.deepHashCode(this.vendor), HidlSupport.deepHashCode(this.version), HidlSupport.deepHashCode(this.fifoReservedCount), HidlSupport.deepHashCode(this.fifoMaxCount), HidlSupport.deepHashCode(this.minDelayMs), HidlSupport.deepHashCode(this.maxDelayMs), HidlSupport.deepHashCode(Float.valueOf(this.peakPowerMw)));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".sensorType = ");
        builder.append(SensorType.toString(this.sensorType));
        builder.append(", .type = ");
        builder.append(this.type);
        builder.append(", .name = ");
        builder.append(this.name);
        builder.append(", .vendor = ");
        builder.append(this.vendor);
        builder.append(", .version = ");
        builder.append(this.version);
        builder.append(", .fifoReservedCount = ");
        builder.append(this.fifoReservedCount);
        builder.append(", .fifoMaxCount = ");
        builder.append(this.fifoMaxCount);
        builder.append(", .minDelayMs = ");
        builder.append(this.minDelayMs);
        builder.append(", .maxDelayMs = ");
        builder.append(this.maxDelayMs);
        builder.append(", .peakPowerMw = ");
        builder.append(this.peakPowerMw);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(96L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<PhysicalSensor> readVectorFromParcel(HwParcel parcel) {
        ArrayList<PhysicalSensor> _hidl_vec = new ArrayList<PhysicalSensor>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 96, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            PhysicalSensor _hidl_vec_element = new PhysicalSensor();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 96);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.sensorType = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.type = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.type.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.name = _hidl_blob.getString(_hidl_offset + 24L);
        parcel.readEmbeddedBuffer(this.name.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 24L + 0L, false);
        this.vendor = _hidl_blob.getString(_hidl_offset + 40L);
        parcel.readEmbeddedBuffer(this.vendor.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 40L + 0L, false);
        this.version = _hidl_blob.getInt32(_hidl_offset + 56L);
        this.fifoReservedCount = _hidl_blob.getInt32(_hidl_offset + 60L);
        this.fifoMaxCount = _hidl_blob.getInt32(_hidl_offset + 64L);
        this.minDelayMs = _hidl_blob.getInt64(_hidl_offset + 72L);
        this.maxDelayMs = _hidl_blob.getInt64(_hidl_offset + 80L);
        this.peakPowerMw = _hidl_blob.getFloat(_hidl_offset + 88L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(96);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<PhysicalSensor> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 96);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 96);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.sensorType);
        _hidl_blob.putString(_hidl_offset + 8L, this.type);
        _hidl_blob.putString(_hidl_offset + 24L, this.name);
        _hidl_blob.putString(_hidl_offset + 40L, this.vendor);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.version);
        _hidl_blob.putInt32(_hidl_offset + 60L, this.fifoReservedCount);
        _hidl_blob.putInt32(_hidl_offset + 64L, this.fifoMaxCount);
        _hidl_blob.putInt64(_hidl_offset + 72L, this.minDelayMs);
        _hidl_blob.putInt64(_hidl_offset + 80L, this.maxDelayMs);
        _hidl_blob.putFloat(_hidl_offset + 88L, this.peakPowerMw);
    }
}

