/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.os.Build;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.TextUtils;

public class AmbientDisplayConfiguration {
    private final Context mContext;
    private final boolean mAlwaysOnByDefault;

    public AmbientDisplayConfiguration(Context context) {
        this.mContext = context;
        this.mAlwaysOnByDefault = this.mContext.getResources().getBoolean(17891418);
    }

    public boolean enabled(int user) {
        return this.pulseOnNotificationEnabled(user) || this.pulseOnLongPressEnabled(user) || this.alwaysOnEnabled(user) || this.wakeScreenGestureEnabled(user) || this.pickupGestureEnabled(user) || this.tapGestureEnabled(user) || this.doubleTapGestureEnabled(user);
    }

    public boolean pulseOnNotificationEnabled(int user) {
        return this.boolSettingDefaultOn("doze_enabled", user) && this.pulseOnNotificationAvailable();
    }

    public boolean pulseOnNotificationAvailable() {
        return this.ambientDisplayAvailable();
    }

    public boolean pickupGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_pick_up", user) && this.dozePickupSensorAvailable();
    }

    public boolean dozePickupSensorAvailable() {
        return this.mContext.getResources().getBoolean(17891419);
    }

    public boolean tapGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_tap_gesture", user) && this.tapSensorAvailable();
    }

    public boolean tapSensorAvailable() {
        return !TextUtils.isEmpty(this.tapSensorType());
    }

    public boolean doubleTapGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_double_tap", user) && this.doubleTapSensorAvailable();
    }

    public boolean doubleTapSensorAvailable() {
        return !TextUtils.isEmpty(this.doubleTapSensorType());
    }

    public boolean wakeScreenGestureAvailable() {
        return this.mContext.getResources().getBoolean(17891421);
    }

    public boolean wakeScreenGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_wake_screen_gesture", user) && this.wakeScreenGestureAvailable();
    }

    public long getWakeLockScreenDebounce() {
        return this.mContext.getResources().getInteger(17694800);
    }

    public String doubleTapSensorType() {
        return this.mContext.getResources().getString(17039724);
    }

    public String tapSensorType() {
        return this.mContext.getResources().getString(17039726);
    }

    public String longPressSensorType() {
        return this.mContext.getResources().getString(17039725);
    }

    public boolean pulseOnLongPressEnabled(int user) {
        return this.pulseOnLongPressAvailable() && this.boolSettingDefaultOff("doze_pulse_on_long_press", user);
    }

    private boolean pulseOnLongPressAvailable() {
        return !TextUtils.isEmpty(this.longPressSensorType());
    }

    public boolean alwaysOnEnabled(int user) {
        return this.boolSetting("doze_always_on", user, this.mAlwaysOnByDefault ? 1 : 0) && this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public boolean alwaysOnAvailable() {
        return (this.alwaysOnDisplayDebuggingEnabled() || this.alwaysOnDisplayAvailable()) && this.ambientDisplayAvailable();
    }

    public boolean alwaysOnAvailableForUser(int user) {
        return this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public String ambientDisplayComponent() {
        return this.mContext.getResources().getString(17039723);
    }

    public boolean accessibilityInversionEnabled(int user) {
        return this.boolSettingDefaultOff("accessibility_display_inversion_enabled", user);
    }

    public boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty(this.ambientDisplayComponent());
    }

    private boolean alwaysOnDisplayAvailable() {
        return this.mContext.getResources().getBoolean(17891417);
    }

    private boolean alwaysOnDisplayDebuggingEnabled() {
        return SystemProperties.getBoolean("debug.doze.aod", false) && Build.IS_DEBUGGABLE;
    }

    private boolean boolSettingDefaultOn(String name, int user) {
        return this.boolSetting(name, user, 1);
    }

    private boolean boolSettingDefaultOff(String name, int user) {
        return this.boolSetting(name, user, 0);
    }

    private boolean boolSetting(String name, int user, int def) {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, user) != 0;
    }
}

