/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.SensorManager;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.os.Handler;
import android.util.IntArray;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.SurfaceControl;

public abstract class DisplayManagerInternal {
    public abstract void initPowerManagement(DisplayPowerCallbacks var1, Handler var2, SensorManager var3);

    public abstract boolean requestPowerState(DisplayPowerRequest var1, boolean var2);

    public abstract boolean isProximitySensorAvailable();

    public abstract SurfaceControl.ScreenshotGraphicBuffer screenshot(int var1);

    public abstract DisplayInfo getDisplayInfo(int var1);

    public abstract void registerDisplayTransactionListener(DisplayTransactionListener var1);

    public abstract void unregisterDisplayTransactionListener(DisplayTransactionListener var1);

    public abstract void setDisplayInfoOverrideFromWindowManager(int var1, DisplayInfo var2);

    public abstract void getNonOverrideDisplayInfo(int var1, DisplayInfo var2);

    public abstract void performTraversal(SurfaceControl.Transaction var1);

    public abstract void setDisplayProperties(int var1, boolean var2, float var3, int var4, boolean var5);

    public abstract void setDisplayOffsets(int var1, int var2, int var3);

    public abstract void setDisplayScalingDisabled(int var1, boolean var2);

    public abstract void setDisplayAccessUIDs(SparseArray<IntArray> var1);

    public abstract void persistBrightnessTrackerState();

    public abstract void onOverlayChanged();

    public abstract DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributes(int var1);

    public abstract boolean setDisplayedContentSamplingEnabled(int var1, boolean var2, int var3, int var4);

    public abstract DisplayedContentSample getDisplayedContentSample(int var1, long var2, long var4);

    public static interface DisplayTransactionListener {
        public void onDisplayTransaction(SurfaceControl.Transaction var1);
    }

    public static interface DisplayPowerCallbacks {
        public void onStateChanged();

        public void onProximityPositive();

        public void onProximityNegative();

        public void onDisplayStateChange(int var1);

        public void acquireSuspendBlocker();

        public void releaseSuspendBlocker();
    }

    public static final class DisplayPowerRequest {
        public static final int POLICY_OFF = 0;
        public static final int POLICY_DOZE = 1;
        public static final int POLICY_DIM = 2;
        public static final int POLICY_BRIGHT = 3;
        public static final int POLICY_VR = 4;
        public int policy;
        public boolean useProximitySensor;
        public int screenBrightnessOverride;
        public float screenAutoBrightnessAdjustmentOverride;
        public boolean useAutoBrightness;
        public boolean lowPowerMode;
        public float screenLowPowerBrightnessFactor;
        public boolean boostScreenBrightness;
        public boolean blockScreenOn;
        public int dozeScreenBrightness;
        public int dozeScreenState;

        public DisplayPowerRequest() {
            this.policy = 3;
            this.useProximitySensor = false;
            this.screenBrightnessOverride = -1;
            this.useAutoBrightness = false;
            this.screenAutoBrightnessAdjustmentOverride = Float.NaN;
            this.screenLowPowerBrightnessFactor = 0.5f;
            this.blockScreenOn = false;
            this.dozeScreenBrightness = -1;
            this.dozeScreenState = 0;
        }

        public DisplayPowerRequest(DisplayPowerRequest other) {
            this.copyFrom(other);
        }

        public boolean isBrightOrDim() {
            return this.policy == 3 || this.policy == 2;
        }

        public boolean isVr() {
            return this.policy == 4;
        }

        public void copyFrom(DisplayPowerRequest other) {
            this.policy = other.policy;
            this.useProximitySensor = other.useProximitySensor;
            this.screenBrightnessOverride = other.screenBrightnessOverride;
            this.useAutoBrightness = other.useAutoBrightness;
            this.screenAutoBrightnessAdjustmentOverride = other.screenAutoBrightnessAdjustmentOverride;
            this.screenLowPowerBrightnessFactor = other.screenLowPowerBrightnessFactor;
            this.blockScreenOn = other.blockScreenOn;
            this.lowPowerMode = other.lowPowerMode;
            this.boostScreenBrightness = other.boostScreenBrightness;
            this.dozeScreenBrightness = other.dozeScreenBrightness;
            this.dozeScreenState = other.dozeScreenState;
        }

        public boolean equals(Object o) {
            return o instanceof DisplayPowerRequest && this.equals((DisplayPowerRequest)o);
        }

        public boolean equals(DisplayPowerRequest other) {
            return other != null && this.policy == other.policy && this.useProximitySensor == other.useProximitySensor && this.screenBrightnessOverride == other.screenBrightnessOverride && this.useAutoBrightness == other.useAutoBrightness && this.floatEquals(this.screenAutoBrightnessAdjustmentOverride, other.screenAutoBrightnessAdjustmentOverride) && this.screenLowPowerBrightnessFactor == other.screenLowPowerBrightnessFactor && this.blockScreenOn == other.blockScreenOn && this.lowPowerMode == other.lowPowerMode && this.boostScreenBrightness == other.boostScreenBrightness && this.dozeScreenBrightness == other.dozeScreenBrightness && this.dozeScreenState == other.dozeScreenState;
        }

        private boolean floatEquals(float f1, float f2) {
            return f1 == f2 || Float.isNaN(f1) && Float.isNaN(f2);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "policy=" + DisplayPowerRequest.policyToString(this.policy) + ", useProximitySensor=" + this.useProximitySensor + ", screenBrightnessOverride=" + this.screenBrightnessOverride + ", useAutoBrightness=" + this.useAutoBrightness + ", screenAutoBrightnessAdjustmentOverride=" + this.screenAutoBrightnessAdjustmentOverride + ", screenLowPowerBrightnessFactor=" + this.screenLowPowerBrightnessFactor + ", blockScreenOn=" + this.blockScreenOn + ", lowPowerMode=" + this.lowPowerMode + ", boostScreenBrightness=" + this.boostScreenBrightness + ", dozeScreenBrightness=" + this.dozeScreenBrightness + ", dozeScreenState=" + Display.stateToString(this.dozeScreenState);
        }

        public static String policyToString(int policy) {
            switch (policy) {
                case 0: {
                    return "OFF";
                }
                case 1: {
                    return "DOZE";
                }
                case 2: {
                    return "DIM";
                }
                case 3: {
                    return "BRIGHT";
                }
                case 4: {
                    return "VR";
                }
            }
            return Integer.toString(policy);
        }
    }
}

