/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.hardware.display.ColorDisplayManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import java.time.LocalTime;

public class NightDisplayListener {
    private final Context mContext;
    private final ColorDisplayManager mManager;
    private final Handler mHandler;
    private final ContentObserver mContentObserver;
    private final int mUserId;
    private Callback mCallback;

    public NightDisplayListener(Context context) {
        this(context, ActivityManager.getCurrentUser(), new Handler(Looper.getMainLooper()));
    }

    public NightDisplayListener(Context context, Handler handler) {
        this(context, ActivityManager.getCurrentUser(), handler);
    }

    public NightDisplayListener(Context context, int userId, Handler handler) {
        this.mContext = context.getApplicationContext();
        this.mManager = this.mContext.getSystemService(ColorDisplayManager.class);
        this.mUserId = userId;
        this.mHandler = handler;
        this.mContentObserver = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange, Uri uri) {
                String setting;
                super.onChange(selfChange, uri);
                String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                if (setting != null && NightDisplayListener.this.mCallback != null) {
                    switch (setting) {
                        case "night_display_activated": {
                            NightDisplayListener.this.mCallback.onActivated(NightDisplayListener.this.mManager.isNightDisplayActivated());
                            break;
                        }
                        case "night_display_auto_mode": {
                            NightDisplayListener.this.mCallback.onAutoModeChanged(NightDisplayListener.this.mManager.getNightDisplayAutoMode());
                            break;
                        }
                        case "night_display_custom_start_time": {
                            NightDisplayListener.this.mCallback.onCustomStartTimeChanged(NightDisplayListener.this.mManager.getNightDisplayCustomStartTime());
                            break;
                        }
                        case "night_display_custom_end_time": {
                            NightDisplayListener.this.mCallback.onCustomEndTimeChanged(NightDisplayListener.this.mManager.getNightDisplayCustomEndTime());
                            break;
                        }
                        case "night_display_color_temperature": {
                            NightDisplayListener.this.mCallback.onColorTemperatureChanged(NightDisplayListener.this.mManager.getNightDisplayColorTemperature());
                        }
                    }
                }
            }
        };
    }

    public void setCallback(Callback callback) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(() -> this.setCallbackInternal(callback));
        }
        this.setCallbackInternal(callback);
    }

    private void setCallbackInternal(Callback newCallback) {
        Callback oldCallback = this.mCallback;
        if (oldCallback != newCallback) {
            this.mCallback = newCallback;
            if (this.mCallback == null) {
                this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            } else if (oldCallback == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mUserId);
            }
        }
    }

    public static interface Callback {
        default public void onActivated(boolean activated) {
        }

        default public void onAutoModeChanged(int autoMode) {
        }

        default public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        default public void onCustomEndTimeChanged(LocalTime endTime) {
        }

        default public void onColorTemperatureChanged(int colorTemperature) {
        }
    }
}

