/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.IHdmiControlService;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;

public final class HdmiAudioSystemClient
extends HdmiClient {
    private static final String TAG = "HdmiAudioSystemClient";
    private static final int REPORT_AUDIO_STATUS_INTERVAL_MS = 500;
    private final Handler mHandler;
    private boolean mCanSendAudioStatus = true;
    private boolean mPendingReportAudioStatus;
    private int mLastVolume;
    private int mLastMaxVolume;
    private boolean mLastIsMute;

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public HdmiAudioSystemClient(IHdmiControlService service) {
        this(service, null);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public HdmiAudioSystemClient(IHdmiControlService service, Handler handler) {
        super(service);
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
    }

    @Override
    public int getDeviceType() {
        return 5;
    }

    public void sendReportAudioStatusCecCommand(boolean isMuteAdjust, int volume, int maxVolume, boolean isMute) {
        if (isMuteAdjust) {
            try {
                this.mService.reportAudioStatus(this.getDeviceType(), volume, maxVolume, isMute);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        this.mLastVolume = volume;
        this.mLastMaxVolume = maxVolume;
        this.mLastIsMute = isMute;
        if (this.mCanSendAudioStatus) {
            try {
                this.mService.reportAudioStatus(this.getDeviceType(), volume, maxVolume, isMute);
                this.mCanSendAudioStatus = false;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (HdmiAudioSystemClient.this.mPendingReportAudioStatus) {
                            try {
                                HdmiAudioSystemClient.this.mService.reportAudioStatus(HdmiAudioSystemClient.this.getDeviceType(), HdmiAudioSystemClient.this.mLastVolume, HdmiAudioSystemClient.this.mLastMaxVolume, HdmiAudioSystemClient.this.mLastIsMute);
                                HdmiAudioSystemClient.this.mHandler.postDelayed(this, 500L);
                            }
                            catch (RemoteException e) {
                                HdmiAudioSystemClient.this.mCanSendAudioStatus = true;
                            }
                            finally {
                                HdmiAudioSystemClient.this.mPendingReportAudioStatus = false;
                            }
                        } else {
                            HdmiAudioSystemClient.this.mCanSendAudioStatus = true;
                        }
                    }
                }, 500L);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mPendingReportAudioStatus = true;
        }
    }

    public void setSystemAudioMode(boolean state, SetSystemAudioModeCallback callback) {
    }

    public void setSystemAudioModeOnForAudioOnlySource() {
        try {
            this.mService.setSystemAudioModeOnForAudioOnlySource();
        }
        catch (RemoteException e) {
            Log.d(TAG, "Failed to set System Audio Mode on for Audio Only source");
        }
    }

    public static interface SetSystemAudioModeCallback {
        public void onComplete(int var1);
    }
}

