/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.health.V2_0;

import android.hardware.health.V2_0.StorageAttribute;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DiskStats {
    public long reads;
    public long readMerges;
    public long readSectors;
    public long readTicks;
    public long writes;
    public long writeMerges;
    public long writeSectors;
    public long writeTicks;
    public long ioInFlight;
    public long ioTicks;
    public long ioInQueue;
    public StorageAttribute attr = new StorageAttribute();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != DiskStats.class) {
            return false;
        }
        DiskStats other = (DiskStats)otherObject;
        if (this.reads != other.reads) {
            return false;
        }
        if (this.readMerges != other.readMerges) {
            return false;
        }
        if (this.readSectors != other.readSectors) {
            return false;
        }
        if (this.readTicks != other.readTicks) {
            return false;
        }
        if (this.writes != other.writes) {
            return false;
        }
        if (this.writeMerges != other.writeMerges) {
            return false;
        }
        if (this.writeSectors != other.writeSectors) {
            return false;
        }
        if (this.writeTicks != other.writeTicks) {
            return false;
        }
        if (this.ioInFlight != other.ioInFlight) {
            return false;
        }
        if (this.ioTicks != other.ioTicks) {
            return false;
        }
        if (this.ioInQueue != other.ioInQueue) {
            return false;
        }
        return HidlSupport.deepEquals(this.attr, other.attr);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.reads), HidlSupport.deepHashCode(this.readMerges), HidlSupport.deepHashCode(this.readSectors), HidlSupport.deepHashCode(this.readTicks), HidlSupport.deepHashCode(this.writes), HidlSupport.deepHashCode(this.writeMerges), HidlSupport.deepHashCode(this.writeSectors), HidlSupport.deepHashCode(this.writeTicks), HidlSupport.deepHashCode(this.ioInFlight), HidlSupport.deepHashCode(this.ioTicks), HidlSupport.deepHashCode(this.ioInQueue), HidlSupport.deepHashCode(this.attr));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".reads = ");
        builder.append(this.reads);
        builder.append(", .readMerges = ");
        builder.append(this.readMerges);
        builder.append(", .readSectors = ");
        builder.append(this.readSectors);
        builder.append(", .readTicks = ");
        builder.append(this.readTicks);
        builder.append(", .writes = ");
        builder.append(this.writes);
        builder.append(", .writeMerges = ");
        builder.append(this.writeMerges);
        builder.append(", .writeSectors = ");
        builder.append(this.writeSectors);
        builder.append(", .writeTicks = ");
        builder.append(this.writeTicks);
        builder.append(", .ioInFlight = ");
        builder.append(this.ioInFlight);
        builder.append(", .ioTicks = ");
        builder.append(this.ioTicks);
        builder.append(", .ioInQueue = ");
        builder.append(this.ioInQueue);
        builder.append(", .attr = ");
        builder.append(this.attr);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(112L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DiskStats> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DiskStats> _hidl_vec = new ArrayList<DiskStats>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DiskStats _hidl_vec_element = new DiskStats();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.reads = _hidl_blob.getInt64(_hidl_offset + 0L);
        this.readMerges = _hidl_blob.getInt64(_hidl_offset + 8L);
        this.readSectors = _hidl_blob.getInt64(_hidl_offset + 16L);
        this.readTicks = _hidl_blob.getInt64(_hidl_offset + 24L);
        this.writes = _hidl_blob.getInt64(_hidl_offset + 32L);
        this.writeMerges = _hidl_blob.getInt64(_hidl_offset + 40L);
        this.writeSectors = _hidl_blob.getInt64(_hidl_offset + 48L);
        this.writeTicks = _hidl_blob.getInt64(_hidl_offset + 56L);
        this.ioInFlight = _hidl_blob.getInt64(_hidl_offset + 64L);
        this.ioTicks = _hidl_blob.getInt64(_hidl_offset + 72L);
        this.ioInQueue = _hidl_blob.getInt64(_hidl_offset + 80L);
        this.attr.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 88L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(112);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DiskStats> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 112);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt64(_hidl_offset + 0L, this.reads);
        _hidl_blob.putInt64(_hidl_offset + 8L, this.readMerges);
        _hidl_blob.putInt64(_hidl_offset + 16L, this.readSectors);
        _hidl_blob.putInt64(_hidl_offset + 24L, this.readTicks);
        _hidl_blob.putInt64(_hidl_offset + 32L, this.writes);
        _hidl_blob.putInt64(_hidl_offset + 40L, this.writeMerges);
        _hidl_blob.putInt64(_hidl_offset + 48L, this.writeSectors);
        _hidl_blob.putInt64(_hidl_offset + 56L, this.writeTicks);
        _hidl_blob.putInt64(_hidl_offset + 64L, this.ioInFlight);
        _hidl_blob.putInt64(_hidl_offset + 72L, this.ioTicks);
        _hidl_blob.putInt64(_hidl_offset + 80L, this.ioInQueue);
        this.attr.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 88L);
    }
}

