/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.health.V2_0;

import android.hardware.health.V2_0.DiskStats;
import android.hardware.health.V2_0.StorageInfo;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class HealthInfo {
    public android.hardware.health.V1_0.HealthInfo legacy = new android.hardware.health.V1_0.HealthInfo();
    public int batteryCurrentAverage;
    public ArrayList<DiskStats> diskStats = new ArrayList();
    public ArrayList<StorageInfo> storageInfos = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != HealthInfo.class) {
            return false;
        }
        HealthInfo other = (HealthInfo)otherObject;
        if (!HidlSupport.deepEquals(this.legacy, other.legacy)) {
            return false;
        }
        if (this.batteryCurrentAverage != other.batteryCurrentAverage) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.diskStats, other.diskStats)) {
            return false;
        }
        return HidlSupport.deepEquals(this.storageInfos, other.storageInfos);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.legacy), HidlSupport.deepHashCode(this.batteryCurrentAverage), HidlSupport.deepHashCode(this.diskStats), HidlSupport.deepHashCode(this.storageInfos));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".legacy = ");
        builder.append(this.legacy);
        builder.append(", .batteryCurrentAverage = ");
        builder.append(this.batteryCurrentAverage);
        builder.append(", .diskStats = ");
        builder.append(this.diskStats);
        builder.append(", .storageInfos = ");
        builder.append(this.storageInfos);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(112L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<HealthInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<HealthInfo> _hidl_vec = new ArrayList<HealthInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            HealthInfo _hidl_vec_element = new HealthInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.legacy.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.batteryCurrentAverage = _hidl_blob.getInt32(_hidl_offset + 72L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 80L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), _hidl_offset + 80L + 0L, true);
        this.diskStats.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new DiskStats();
            ((DiskStats)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            this.diskStats.add((DiskStats)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 96L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), _hidl_offset + 96L + 0L, true);
        this.storageInfos.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new StorageInfo();
            ((StorageInfo)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            this.storageInfos.add((StorageInfo)_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(112);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<HealthInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 112);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        this.legacy.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        _hidl_blob.putInt32(_hidl_offset + 72L, this.batteryCurrentAverage);
        int _hidl_vec_size = this.diskStats.size();
        _hidl_blob.putInt32(_hidl_offset + 80L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 80L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 112);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.diskStats.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(_hidl_offset + 80L + 0L, childBlob);
        _hidl_vec_size = this.storageInfos.size();
        _hidl_blob.putInt32(_hidl_offset + 96L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 96L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 48);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.storageInfos.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(_hidl_offset + 96L + 0L, childBlob);
    }
}

