/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ActivityChangedEvent;
import android.hardware.location.ActivityRecognitionEvent;
import android.hardware.location.IActivityRecognitionHardware;
import android.hardware.location.IActivityRecognitionHardwareSink;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

public class ActivityRecognitionHardware
extends IActivityRecognitionHardware.Stub {
    private static final String TAG = "ActivityRecognitionHW";
    private static final boolean DEBUG = Log.isLoggable("ActivityRecognitionHW", 3);
    private static final String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static final String ENFORCE_HW_PERMISSION_MESSAGE = "Permission 'android.permission.LOCATION_HARDWARE' not granted to access ActivityRecognitionHardware";
    private static final int INVALID_ACTIVITY_TYPE = -1;
    private static final int NATIVE_SUCCESS_RESULT = 0;
    private static final int EVENT_TYPE_DISABLED = 0;
    private static final int EVENT_TYPE_ENABLED = 1;
    private static final int EVENT_TYPE_COUNT = 3;
    private static ActivityRecognitionHardware sSingletonInstance;
    private static final Object sSingletonInstanceLock;
    private final Context mContext;
    private final int mSupportedActivitiesCount;
    private final String[] mSupportedActivities;
    private final int[][] mSupportedActivitiesEnabledEvents;
    private final SinkList mSinks = new SinkList();

    private ActivityRecognitionHardware(Context context) {
        this.nativeInitialize();
        this.mContext = context;
        this.mSupportedActivities = this.fetchSupportedActivities();
        this.mSupportedActivitiesCount = this.mSupportedActivities.length;
        this.mSupportedActivitiesEnabledEvents = new int[this.mSupportedActivitiesCount][3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityRecognitionHardware getInstance(Context context) {
        Object object = sSingletonInstanceLock;
        synchronized (object) {
            if (sSingletonInstance == null) {
                sSingletonInstance = new ActivityRecognitionHardware(context);
            }
            return sSingletonInstance;
        }
    }

    public static boolean isSupported() {
        return ActivityRecognitionHardware.nativeIsSupported();
    }

    @Override
    public String[] getSupportedActivities() {
        this.checkPermissions();
        return this.mSupportedActivities;
    }

    @Override
    public boolean isActivitySupported(String activity) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        return activityType != -1;
    }

    @Override
    public boolean registerSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.register(sink);
    }

    @Override
    public boolean unregisterSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.unregister(sink);
    }

    @Override
    public boolean enableActivityEvent(String activity, int eventType, long reportLatencyNs) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeEnableActivityEvent(activityType, eventType, reportLatencyNs);
        if (result == 0) {
            this.mSupportedActivitiesEnabledEvents[activityType][eventType] = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean disableActivityEvent(String activity, int eventType) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeDisableActivityEvent(activityType, eventType);
        if (result == 0) {
            this.mSupportedActivitiesEnabledEvents[activityType][eventType] = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean flush() {
        this.checkPermissions();
        int result = this.nativeFlush();
        return result == 0;
    }

    private void onActivityChanged(Event[] events) {
        if (events == null || events.length == 0) {
            if (DEBUG) {
                Log.d(TAG, "No events to broadcast for onActivityChanged.");
            }
            return;
        }
        int eventsLength = events.length;
        ActivityRecognitionEvent[] activityRecognitionEventArray = new ActivityRecognitionEvent[eventsLength];
        for (int i = 0; i < eventsLength; ++i) {
            Event event = events[i];
            String activityName = this.getActivityName(event.activity);
            activityRecognitionEventArray[i] = new ActivityRecognitionEvent(activityName, event.type, event.timestamp);
        }
        ActivityChangedEvent activityChangedEvent = new ActivityChangedEvent(activityRecognitionEventArray);
        int size = this.mSinks.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IActivityRecognitionHardwareSink sink = (IActivityRecognitionHardwareSink)this.mSinks.getBroadcastItem(i);
            try {
                sink.onActivityChanged(activityChangedEvent);
                continue;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error delivering activity changed event.", e);
            }
        }
        this.mSinks.finishBroadcast();
    }

    private String getActivityName(int activityType) {
        if (activityType < 0 || activityType >= this.mSupportedActivities.length) {
            String message = String.format("Invalid ActivityType: %d, SupportedActivities: %d", activityType, this.mSupportedActivities.length);
            Log.e(TAG, message);
            return null;
        }
        return this.mSupportedActivities[activityType];
    }

    private int getActivityType(String activity) {
        if (TextUtils.isEmpty(activity)) {
            return -1;
        }
        int supportedActivitiesLength = this.mSupportedActivities.length;
        for (int i = 0; i < supportedActivitiesLength; ++i) {
            if (!activity.equals(this.mSupportedActivities[i])) continue;
            return i;
        }
        return -1;
    }

    private void checkPermissions() {
        this.mContext.enforceCallingPermission(HARDWARE_PERMISSION, ENFORCE_HW_PERMISSION_MESSAGE);
    }

    private String[] fetchSupportedActivities() {
        String[] supportedActivities = this.nativeGetSupportedActivities();
        if (supportedActivities != null) {
            return supportedActivities;
        }
        return new String[0];
    }

    private static native void nativeClassInit();

    private static native boolean nativeIsSupported();

    private native void nativeInitialize();

    private native void nativeRelease();

    private native String[] nativeGetSupportedActivities();

    private native int nativeEnableActivityEvent(int var1, int var2, long var3);

    private native int nativeDisableActivityEvent(int var1, int var2);

    private native int nativeFlush();

    static {
        sSingletonInstanceLock = new Object();
        ActivityRecognitionHardware.nativeClassInit();
    }

    private class SinkList
    extends RemoteCallbackList<IActivityRecognitionHardwareSink> {
        private SinkList() {
        }

        @Override
        public void onCallbackDied(IActivityRecognitionHardwareSink callback) {
            int callbackCount = ActivityRecognitionHardware.this.mSinks.getRegisteredCallbackCount();
            if (DEBUG) {
                Log.d(ActivityRecognitionHardware.TAG, "RegisteredCallbackCount: " + callbackCount);
            }
            if (callbackCount != 0) {
                return;
            }
            for (int activity = 0; activity < ActivityRecognitionHardware.this.mSupportedActivitiesCount; ++activity) {
                for (int event = 0; event < 3; ++event) {
                    this.disableActivityEventIfEnabled(activity, event);
                }
            }
        }

        private void disableActivityEventIfEnabled(int activityType, int eventType) {
            if (ActivityRecognitionHardware.this.mSupportedActivitiesEnabledEvents[activityType][eventType] != 1) {
                return;
            }
            int result = ActivityRecognitionHardware.this.nativeDisableActivityEvent(activityType, eventType);
            ((ActivityRecognitionHardware)ActivityRecognitionHardware.this).mSupportedActivitiesEnabledEvents[activityType][eventType] = 0;
            String message = String.format("DisableActivityEvent: activityType=%d, eventType=%d, result=%d", activityType, eventType, result);
            Log.e(ActivityRecognitionHardware.TAG, message);
        }
    }

    private static class Event {
        public int activity;
        public int type;
        public long timestamp;

        private Event() {
        }
    }
}

