/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.content.Intent;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.NanoAppMessage;
import com.android.internal.util.Preconditions;

@SystemApi
public class ContextHubIntentEvent {
    private final int mEventType;
    private final ContextHubInfo mContextHubInfo;
    private final long mNanoAppId;
    private final NanoAppMessage mNanoAppMessage;
    private final int mNanoAppAbortCode;

    private ContextHubIntentEvent(ContextHubInfo contextHubInfo, int eventType, long nanoAppId, NanoAppMessage nanoAppMessage, int nanoAppAbortCode) {
        this.mContextHubInfo = contextHubInfo;
        this.mEventType = eventType;
        this.mNanoAppId = nanoAppId;
        this.mNanoAppMessage = nanoAppMessage;
        this.mNanoAppAbortCode = nanoAppAbortCode;
    }

    private ContextHubIntentEvent(ContextHubInfo contextHubInfo, int eventType) {
        this(contextHubInfo, eventType, -1L, null, -1);
    }

    private ContextHubIntentEvent(ContextHubInfo contextHubInfo, int eventType, long nanoAppId) {
        this(contextHubInfo, eventType, nanoAppId, null, -1);
    }

    private ContextHubIntentEvent(ContextHubInfo contextHubInfo, int eventType, long nanoAppId, NanoAppMessage nanoAppMessage) {
        this(contextHubInfo, eventType, nanoAppId, nanoAppMessage, -1);
    }

    private ContextHubIntentEvent(ContextHubInfo contextHubInfo, int eventType, long nanoAppId, int nanoAppAbortCode) {
        this(contextHubInfo, eventType, nanoAppId, null, nanoAppAbortCode);
    }

    public static ContextHubIntentEvent fromIntent(Intent intent) {
        ContextHubIntentEvent event;
        Preconditions.checkNotNull(intent, "Intent cannot be null");
        ContextHubIntentEvent.hasExtraOrThrow(intent, "android.hardware.location.extra.CONTEXT_HUB_INFO");
        ContextHubInfo info = (ContextHubInfo)intent.getParcelableExtra("android.hardware.location.extra.CONTEXT_HUB_INFO");
        if (info == null) {
            throw new IllegalArgumentException("ContextHubInfo extra was null");
        }
        int eventType = ContextHubIntentEvent.getIntExtraOrThrow(intent, "android.hardware.location.extra.EVENT_TYPE");
        switch (eventType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                long nanoAppId = ContextHubIntentEvent.getLongExtraOrThrow(intent, "android.hardware.location.extra.NANOAPP_ID");
                if (eventType == 5) {
                    ContextHubIntentEvent.hasExtraOrThrow(intent, "android.hardware.location.extra.MESSAGE");
                    NanoAppMessage message = (NanoAppMessage)intent.getParcelableExtra("android.hardware.location.extra.MESSAGE");
                    if (message == null) {
                        throw new IllegalArgumentException("NanoAppMessage extra was null");
                    }
                    event = new ContextHubIntentEvent(info, eventType, nanoAppId, message);
                    break;
                }
                if (eventType == 4) {
                    int nanoAppAbortCode = ContextHubIntentEvent.getIntExtraOrThrow(intent, "android.hardware.location.extra.NANOAPP_ABORT_CODE");
                    event = new ContextHubIntentEvent(info, eventType, nanoAppId, nanoAppAbortCode);
                    break;
                }
                event = new ContextHubIntentEvent(info, eventType, nanoAppId);
                break;
            }
            case 6: {
                event = new ContextHubIntentEvent(info, eventType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown intent event type " + eventType);
            }
        }
        return event;
    }

    public int getEventType() {
        return this.mEventType;
    }

    public ContextHubInfo getContextHubInfo() {
        return this.mContextHubInfo;
    }

    public long getNanoAppId() {
        if (this.mEventType == 6) {
            throw new UnsupportedOperationException("Cannot invoke getNanoAppId() on Context Hub reset event");
        }
        return this.mNanoAppId;
    }

    public int getNanoAppAbortCode() {
        if (this.mEventType != 4) {
            throw new UnsupportedOperationException("Cannot invoke getNanoAppAbortCode() on non-abort event: " + this.mEventType);
        }
        return this.mNanoAppAbortCode;
    }

    public NanoAppMessage getNanoAppMessage() {
        if (this.mEventType != 5) {
            throw new UnsupportedOperationException("Cannot invoke getNanoAppMessage() on non-message event: " + this.mEventType);
        }
        return this.mNanoAppMessage;
    }

    public String toString() {
        String out = "ContextHubIntentEvent[eventType = " + this.mEventType + ", contextHubId = " + this.mContextHubInfo.getId();
        if (this.mEventType != 6) {
            out = out + ", nanoAppId = 0x" + Long.toHexString(this.mNanoAppId);
        }
        if (this.mEventType == 4) {
            out = out + ", nanoAppAbortCode = " + this.mNanoAppAbortCode;
        }
        if (this.mEventType == 5) {
            out = out + ", nanoAppMessage = " + this.mNanoAppMessage;
        }
        return out + "]";
    }

    public boolean equals(Object object) {
        ContextHubIntentEvent other;
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof ContextHubIntentEvent && (other = (ContextHubIntentEvent)object).getEventType() == this.mEventType && other.getContextHubInfo().equals(this.mContextHubInfo)) {
            isEqual = true;
            try {
                if (this.mEventType != 6) {
                    isEqual &= other.getNanoAppId() == this.mNanoAppId;
                }
                if (this.mEventType == 4) {
                    isEqual &= other.getNanoAppAbortCode() == this.mNanoAppAbortCode;
                }
                if (this.mEventType == 5) {
                    isEqual &= other.getNanoAppMessage().equals(this.mNanoAppMessage);
                }
            }
            catch (UnsupportedOperationException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    private static void hasExtraOrThrow(Intent intent, String extra) {
        if (!intent.hasExtra(extra)) {
            throw new IllegalArgumentException("Intent did not have extra: " + extra);
        }
    }

    private static int getIntExtraOrThrow(Intent intent, String extra) {
        ContextHubIntentEvent.hasExtraOrThrow(intent, extra);
        return intent.getIntExtra(extra, -1);
    }

    private static long getLongExtraOrThrow(Intent intent, String extra) {
        ContextHubIntentEvent.hasExtraOrThrow(intent, extra);
        return intent.getLongExtra(extra, -1L);
    }
}

