/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.CallForwardInfoStatus;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CallForwardInfo {
    public int status;
    public int reason;
    public int serviceClass;
    public int toa;
    public String number = new String();
    public int timeSeconds;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CallForwardInfo.class) {
            return false;
        }
        CallForwardInfo other = (CallForwardInfo)otherObject;
        if (this.status != other.status) {
            return false;
        }
        if (this.reason != other.reason) {
            return false;
        }
        if (this.serviceClass != other.serviceClass) {
            return false;
        }
        if (this.toa != other.toa) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.number, other.number)) {
            return false;
        }
        return this.timeSeconds == other.timeSeconds;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.status), HidlSupport.deepHashCode(this.reason), HidlSupport.deepHashCode(this.serviceClass), HidlSupport.deepHashCode(this.toa), HidlSupport.deepHashCode(this.number), HidlSupport.deepHashCode(this.timeSeconds));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".status = ");
        builder.append(CallForwardInfoStatus.toString(this.status));
        builder.append(", .reason = ");
        builder.append(this.reason);
        builder.append(", .serviceClass = ");
        builder.append(this.serviceClass);
        builder.append(", .toa = ");
        builder.append(this.toa);
        builder.append(", .number = ");
        builder.append(this.number);
        builder.append(", .timeSeconds = ");
        builder.append(this.timeSeconds);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CallForwardInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CallForwardInfo> _hidl_vec = new ArrayList<CallForwardInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CallForwardInfo _hidl_vec_element = new CallForwardInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.status = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.reason = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.serviceClass = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.toa = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.number = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.number.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.timeSeconds = _hidl_blob.getInt32(_hidl_offset + 32L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CallForwardInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.status);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.reason);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.serviceClass);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.toa);
        _hidl_blob.putString(_hidl_offset + 16L, this.number);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.timeSeconds);
    }
}

