/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.CarrierMatchType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class Carrier {
    public String mcc = new String();
    public String mnc = new String();
    public int matchType;
    public String matchData = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != Carrier.class) {
            return false;
        }
        Carrier other = (Carrier)otherObject;
        if (!HidlSupport.deepEquals(this.mcc, other.mcc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.mnc, other.mnc)) {
            return false;
        }
        if (this.matchType != other.matchType) {
            return false;
        }
        return HidlSupport.deepEquals(this.matchData, other.matchData);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.mcc), HidlSupport.deepHashCode(this.mnc), HidlSupport.deepHashCode(this.matchType), HidlSupport.deepHashCode(this.matchData));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".mcc = ");
        builder.append(this.mcc);
        builder.append(", .mnc = ");
        builder.append(this.mnc);
        builder.append(", .matchType = ");
        builder.append(CarrierMatchType.toString(this.matchType));
        builder.append(", .matchData = ");
        builder.append(this.matchData);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(56L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<Carrier> readVectorFromParcel(HwParcel parcel) {
        ArrayList<Carrier> _hidl_vec = new ArrayList<Carrier>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 56, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            Carrier _hidl_vec_element = new Carrier();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 56);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.mcc = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.mcc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.mnc = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.mnc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.matchType = _hidl_blob.getInt32(_hidl_offset + 32L);
        this.matchData = _hidl_blob.getString(_hidl_offset + 40L);
        parcel.readEmbeddedBuffer(this.matchData.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 40L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(56);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<Carrier> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 56);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 56);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.mcc);
        _hidl_blob.putString(_hidl_offset + 16L, this.mnc);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.matchType);
        _hidl_blob.putString(_hidl_offset + 40L, this.matchData);
    }
}

