/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.CellIdentity;
import android.hardware.radio.V1_0.RegState;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DataRegStateResult {
    public int regState;
    public int rat;
    public int reasonDataDenied;
    public int maxDataCalls;
    public CellIdentity cellIdentity = new CellIdentity();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != DataRegStateResult.class) {
            return false;
        }
        DataRegStateResult other = (DataRegStateResult)otherObject;
        if (this.regState != other.regState) {
            return false;
        }
        if (this.rat != other.rat) {
            return false;
        }
        if (this.reasonDataDenied != other.reasonDataDenied) {
            return false;
        }
        if (this.maxDataCalls != other.maxDataCalls) {
            return false;
        }
        return HidlSupport.deepEquals(this.cellIdentity, other.cellIdentity);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.regState), HidlSupport.deepHashCode(this.rat), HidlSupport.deepHashCode(this.reasonDataDenied), HidlSupport.deepHashCode(this.maxDataCalls), HidlSupport.deepHashCode(this.cellIdentity));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".regState = ");
        builder.append(RegState.toString(this.regState));
        builder.append(", .rat = ");
        builder.append(this.rat);
        builder.append(", .reasonDataDenied = ");
        builder.append(this.reasonDataDenied);
        builder.append(", .maxDataCalls = ");
        builder.append(this.maxDataCalls);
        builder.append(", .cellIdentity = ");
        builder.append(this.cellIdentity);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(104L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DataRegStateResult> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DataRegStateResult> _hidl_vec = new ArrayList<DataRegStateResult>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 104, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DataRegStateResult _hidl_vec_element = new DataRegStateResult();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 104);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.regState = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.rat = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.reasonDataDenied = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.maxDataCalls = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.cellIdentity.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 16L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(104);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DataRegStateResult> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 104);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 104);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.regState);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.rat);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.reasonDataDenied);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.maxDataCalls);
        this.cellIdentity.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 16L);
    }
}

