/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.HardwareConfigModem;
import android.hardware.radio.V1_0.HardwareConfigSim;
import android.hardware.radio.V1_0.HardwareConfigState;
import android.hardware.radio.V1_0.HardwareConfigType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class HardwareConfig {
    public int type;
    public String uuid = new String();
    public int state;
    public ArrayList<HardwareConfigModem> modem = new ArrayList();
    public ArrayList<HardwareConfigSim> sim = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != HardwareConfig.class) {
            return false;
        }
        HardwareConfig other = (HardwareConfig)otherObject;
        if (this.type != other.type) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.uuid, other.uuid)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.modem, other.modem)) {
            return false;
        }
        return HidlSupport.deepEquals(this.sim, other.sim);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.uuid), HidlSupport.deepHashCode(this.state), HidlSupport.deepHashCode(this.modem), HidlSupport.deepHashCode(this.sim));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".type = ");
        builder.append(HardwareConfigType.toString(this.type));
        builder.append(", .uuid = ");
        builder.append(this.uuid);
        builder.append(", .state = ");
        builder.append(HardwareConfigState.toString(this.state));
        builder.append(", .modem = ");
        builder.append(this.modem);
        builder.append(", .sim = ");
        builder.append(this.sim);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(64L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<HardwareConfig> readVectorFromParcel(HwParcel parcel) {
        ArrayList<HardwareConfig> _hidl_vec = new ArrayList<HardwareConfig>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 64, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            HardwareConfig _hidl_vec_element = new HardwareConfig();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 64);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.type = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.uuid = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.uuid.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.state = _hidl_blob.getInt32(_hidl_offset + 24L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 20, _hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
        this.modem.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new HardwareConfigModem();
            ((HardwareConfigModem)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 20);
            this.modem.add((HardwareConfigModem)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 48L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), _hidl_offset + 48L + 0L, true);
        this.sim.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new HardwareConfigSim();
            ((HardwareConfigSim)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            this.sim.add((HardwareConfigSim)_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(64);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<HardwareConfig> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 64);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 64);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt32(_hidl_offset + 0L, this.type);
        _hidl_blob.putString(_hidl_offset + 8L, this.uuid);
        _hidl_blob.putInt32(_hidl_offset + 24L, this.state);
        int _hidl_vec_size = this.modem.size();
        _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 20);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.modem.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 20);
        }
        _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
        _hidl_vec_size = this.sim.size();
        _hidl_blob.putInt32(_hidl_offset + 48L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 48L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 16);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.sim.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(_hidl_offset + 48L + 0L, childBlob);
    }
}

