/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.GsmSmsMessage;
import android.hardware.radio.V1_0.RadioTechnologyFamily;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class ImsSmsMessage {
    public int tech;
    public boolean retry;
    public int messageRef;
    public ArrayList<CdmaSmsMessage> cdmaMessage = new ArrayList();
    public ArrayList<GsmSmsMessage> gsmMessage = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ImsSmsMessage.class) {
            return false;
        }
        ImsSmsMessage other = (ImsSmsMessage)otherObject;
        if (this.tech != other.tech) {
            return false;
        }
        if (this.retry != other.retry) {
            return false;
        }
        if (this.messageRef != other.messageRef) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.cdmaMessage, other.cdmaMessage)) {
            return false;
        }
        return HidlSupport.deepEquals(this.gsmMessage, other.gsmMessage);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.tech), HidlSupport.deepHashCode(this.retry), HidlSupport.deepHashCode(this.messageRef), HidlSupport.deepHashCode(this.cdmaMessage), HidlSupport.deepHashCode(this.gsmMessage));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".tech = ");
        builder.append(RadioTechnologyFamily.toString(this.tech));
        builder.append(", .retry = ");
        builder.append(this.retry);
        builder.append(", .messageRef = ");
        builder.append(this.messageRef);
        builder.append(", .cdmaMessage = ");
        builder.append(this.cdmaMessage);
        builder.append(", .gsmMessage = ");
        builder.append(this.gsmMessage);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<ImsSmsMessage> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ImsSmsMessage> _hidl_vec = new ArrayList<ImsSmsMessage>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ImsSmsMessage _hidl_vec_element = new ImsSmsMessage();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.tech = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.retry = _hidl_blob.getBool(_hidl_offset + 4L);
        this.messageRef = _hidl_blob.getInt32(_hidl_offset + 8L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 16L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 88, _hidl_blob.handle(), _hidl_offset + 16L + 0L, true);
        this.cdmaMessage.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CdmaSmsMessage();
            ((CdmaSmsMessage)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 88);
            this.cdmaMessage.add((CdmaSmsMessage)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
        this.gsmMessage.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new GsmSmsMessage();
            ((GsmSmsMessage)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 32);
            this.gsmMessage.add((GsmSmsMessage)_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<ImsSmsMessage> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt32(_hidl_offset + 0L, this.tech);
        _hidl_blob.putBool(_hidl_offset + 4L, this.retry);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.messageRef);
        int _hidl_vec_size = this.cdmaMessage.size();
        _hidl_blob.putInt32(_hidl_offset + 16L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 16L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 88);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.cdmaMessage.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 88);
        }
        _hidl_blob.putBlob(_hidl_offset + 16L + 0L, childBlob);
        _hidl_vec_size = this.gsmMessage.size();
        _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 32);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.gsmMessage.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 32);
        }
        _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
    }
}

