/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.SmsWriteArgsStatus;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class SmsWriteArgs {
    public int status;
    public String pdu = new String();
    public String smsc = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != SmsWriteArgs.class) {
            return false;
        }
        SmsWriteArgs other = (SmsWriteArgs)otherObject;
        if (this.status != other.status) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.pdu, other.pdu)) {
            return false;
        }
        return HidlSupport.deepEquals(this.smsc, other.smsc);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.status), HidlSupport.deepHashCode(this.pdu), HidlSupport.deepHashCode(this.smsc));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".status = ");
        builder.append(SmsWriteArgsStatus.toString(this.status));
        builder.append(", .pdu = ");
        builder.append(this.pdu);
        builder.append(", .smsc = ");
        builder.append(this.smsc);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<SmsWriteArgs> readVectorFromParcel(HwParcel parcel) {
        ArrayList<SmsWriteArgs> _hidl_vec = new ArrayList<SmsWriteArgs>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            SmsWriteArgs _hidl_vec_element = new SmsWriteArgs();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.status = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.pdu = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.pdu.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.smsc = _hidl_blob.getString(_hidl_offset + 24L);
        parcel.readEmbeddedBuffer(this.smsc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 24L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<SmsWriteArgs> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.status);
        _hidl_blob.putString(_hidl_offset + 8L, this.pdu);
        _hidl_blob.putString(_hidl_offset + 24L, this.smsc);
    }
}

