/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_1;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class ImsiEncryptionInfo {
    public String mcc = new String();
    public String mnc = new String();
    public ArrayList<Byte> carrierKey = new ArrayList();
    public String keyIdentifier = new String();
    public long expirationTime;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != ImsiEncryptionInfo.class) {
            return false;
        }
        ImsiEncryptionInfo other = (ImsiEncryptionInfo)otherObject;
        if (!HidlSupport.deepEquals(this.mcc, other.mcc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.mnc, other.mnc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.carrierKey, other.carrierKey)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.keyIdentifier, other.keyIdentifier)) {
            return false;
        }
        return this.expirationTime == other.expirationTime;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.mcc), HidlSupport.deepHashCode(this.mnc), HidlSupport.deepHashCode(this.carrierKey), HidlSupport.deepHashCode(this.keyIdentifier), HidlSupport.deepHashCode(this.expirationTime));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".mcc = ");
        builder.append(this.mcc);
        builder.append(", .mnc = ");
        builder.append(this.mnc);
        builder.append(", .carrierKey = ");
        builder.append(this.carrierKey);
        builder.append(", .keyIdentifier = ");
        builder.append(this.keyIdentifier);
        builder.append(", .expirationTime = ");
        builder.append(this.expirationTime);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(72L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<ImsiEncryptionInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<ImsiEncryptionInfo> _hidl_vec = new ArrayList<ImsiEncryptionInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 72, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ImsiEncryptionInfo _hidl_vec_element = new ImsiEncryptionInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 72);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.mcc = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.mcc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.mnc = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.mnc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
        this.carrierKey.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            byte _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.carrierKey.add(_hidl_vec_element);
        }
        this.keyIdentifier = _hidl_blob.getString(_hidl_offset + 48L);
        parcel.readEmbeddedBuffer(this.keyIdentifier.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 48L + 0L, false);
        this.expirationTime = _hidl_blob.getInt64(_hidl_offset + 64L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(72);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<ImsiEncryptionInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 72);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 72);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.mcc);
        _hidl_blob.putString(_hidl_offset + 16L, this.mnc);
        int _hidl_vec_size = this.carrierKey.size();
        _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.carrierKey.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
        _hidl_blob.putString(_hidl_offset + 48L, this.keyIdentifier);
        _hidl_blob.putInt64(_hidl_offset + 64L, this.expirationTime);
    }
}

