/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_1;

import android.hardware.radio.V1_1.KeepaliveType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class KeepaliveRequest {
    public int type;
    public ArrayList<Byte> sourceAddress = new ArrayList();
    public int sourcePort;
    public ArrayList<Byte> destinationAddress = new ArrayList();
    public int destinationPort;
    public int maxKeepaliveIntervalMillis;
    public int cid;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != KeepaliveRequest.class) {
            return false;
        }
        KeepaliveRequest other = (KeepaliveRequest)otherObject;
        if (this.type != other.type) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.sourceAddress, other.sourceAddress)) {
            return false;
        }
        if (this.sourcePort != other.sourcePort) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.destinationAddress, other.destinationAddress)) {
            return false;
        }
        if (this.destinationPort != other.destinationPort) {
            return false;
        }
        if (this.maxKeepaliveIntervalMillis != other.maxKeepaliveIntervalMillis) {
            return false;
        }
        return this.cid == other.cid;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.sourceAddress), HidlSupport.deepHashCode(this.sourcePort), HidlSupport.deepHashCode(this.destinationAddress), HidlSupport.deepHashCode(this.destinationPort), HidlSupport.deepHashCode(this.maxKeepaliveIntervalMillis), HidlSupport.deepHashCode(this.cid));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".type = ");
        builder.append(KeepaliveType.toString(this.type));
        builder.append(", .sourceAddress = ");
        builder.append(this.sourceAddress);
        builder.append(", .sourcePort = ");
        builder.append(this.sourcePort);
        builder.append(", .destinationAddress = ");
        builder.append(this.destinationAddress);
        builder.append(", .destinationPort = ");
        builder.append(this.destinationPort);
        builder.append(", .maxKeepaliveIntervalMillis = ");
        builder.append(this.maxKeepaliveIntervalMillis);
        builder.append(", .cid = ");
        builder.append(this.cid);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(64L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<KeepaliveRequest> readVectorFromParcel(HwParcel parcel) {
        ArrayList<KeepaliveRequest> _hidl_vec = new ArrayList<KeepaliveRequest>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 64, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            KeepaliveRequest _hidl_vec_element = new KeepaliveRequest();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 64);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        byte _hidl_vec_element;
        int _hidl_index_0;
        this.type = _hidl_blob.getInt32(_hidl_offset + 0L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 8L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, true);
        this.sourceAddress.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.sourceAddress.add(_hidl_vec_element);
        }
        this.sourcePort = _hidl_blob.getInt32(_hidl_offset + 24L);
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
        this.destinationAddress.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.destinationAddress.add(_hidl_vec_element);
        }
        this.destinationPort = _hidl_blob.getInt32(_hidl_offset + 48L);
        this.maxKeepaliveIntervalMillis = _hidl_blob.getInt32(_hidl_offset + 52L);
        this.cid = _hidl_blob.getInt32(_hidl_offset + 56L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(64);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<KeepaliveRequest> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 64);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 64);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt32(_hidl_offset + 0L, this.type);
        int _hidl_vec_size = this.sourceAddress.size();
        _hidl_blob.putInt32(_hidl_offset + 8L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 8L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.sourceAddress.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 8L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 24L, this.sourcePort);
        _hidl_vec_size = this.destinationAddress.size();
        _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 1);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.destinationAddress.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.destinationPort);
        _hidl_blob.putInt32(_hidl_offset + 52L, this.maxKeepaliveIntervalMillis);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.cid);
    }
}

