/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_1;

import android.hardware.radio.V1_1.RadioAccessNetworks;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class RadioAccessSpecifier {
    public int radioAccessNetwork;
    public ArrayList<Integer> geranBands = new ArrayList();
    public ArrayList<Integer> utranBands = new ArrayList();
    public ArrayList<Integer> eutranBands = new ArrayList();
    public ArrayList<Integer> channels = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != RadioAccessSpecifier.class) {
            return false;
        }
        RadioAccessSpecifier other = (RadioAccessSpecifier)otherObject;
        if (this.radioAccessNetwork != other.radioAccessNetwork) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.geranBands, other.geranBands)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.utranBands, other.utranBands)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.eutranBands, other.eutranBands)) {
            return false;
        }
        return HidlSupport.deepEquals(this.channels, other.channels);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.radioAccessNetwork), HidlSupport.deepHashCode(this.geranBands), HidlSupport.deepHashCode(this.utranBands), HidlSupport.deepHashCode(this.eutranBands), HidlSupport.deepHashCode(this.channels));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".radioAccessNetwork = ");
        builder.append(RadioAccessNetworks.toString(this.radioAccessNetwork));
        builder.append(", .geranBands = ");
        builder.append(this.geranBands);
        builder.append(", .utranBands = ");
        builder.append(this.utranBands);
        builder.append(", .eutranBands = ");
        builder.append(this.eutranBands);
        builder.append(", .channels = ");
        builder.append(this.channels);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(72L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<RadioAccessSpecifier> readVectorFromParcel(HwParcel parcel) {
        ArrayList<RadioAccessSpecifier> _hidl_vec = new ArrayList<RadioAccessSpecifier>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 72, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            RadioAccessSpecifier _hidl_vec_element = new RadioAccessSpecifier();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 72);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_vec_element;
        int _hidl_index_0;
        this.radioAccessNetwork = _hidl_blob.getInt32(_hidl_offset + 0L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 8L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), _hidl_offset + 8L + 0L, true);
        this.geranBands.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
            this.geranBands.add(_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 24L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), _hidl_offset + 24L + 0L, true);
        this.utranBands.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
            this.utranBands.add(_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 40L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), _hidl_offset + 40L + 0L, true);
        this.eutranBands.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
            this.eutranBands.add(_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 56L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), _hidl_offset + 56L + 0L, true);
        this.channels.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
            this.channels.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(72);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<RadioAccessSpecifier> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 72);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 72);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt32(_hidl_offset + 0L, this.radioAccessNetwork);
        int _hidl_vec_size = this.geranBands.size();
        _hidl_blob.putInt32(_hidl_offset + 8L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 8L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 4);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt32(_hidl_index_0 * 4, this.geranBands.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 8L + 0L, childBlob);
        _hidl_vec_size = this.utranBands.size();
        _hidl_blob.putInt32(_hidl_offset + 24L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 24L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 4);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt32(_hidl_index_0 * 4, this.utranBands.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 24L + 0L, childBlob);
        _hidl_vec_size = this.eutranBands.size();
        _hidl_blob.putInt32(_hidl_offset + 40L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 40L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 4);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt32(_hidl_index_0 * 4, this.eutranBands.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 40L + 0L, childBlob);
        _hidl_vec_size = this.channels.size();
        _hidl_blob.putInt32(_hidl_offset + 56L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 56L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 4);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt32(_hidl_index_0 * 4, this.channels.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 56L + 0L, childBlob);
    }
}

