/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_2;

import android.hardware.radio.V1_2.CellIdentityWcdma;
import android.hardware.radio.V1_2.WcdmaSignalStrength;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CellInfoWcdma {
    public CellIdentityWcdma cellIdentityWcdma = new CellIdentityWcdma();
    public WcdmaSignalStrength signalStrengthWcdma = new WcdmaSignalStrength();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellInfoWcdma.class) {
            return false;
        }
        CellInfoWcdma other = (CellInfoWcdma)otherObject;
        if (!HidlSupport.deepEquals(this.cellIdentityWcdma, other.cellIdentityWcdma)) {
            return false;
        }
        return HidlSupport.deepEquals(this.signalStrengthWcdma, other.signalStrengthWcdma);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.cellIdentityWcdma), HidlSupport.deepHashCode(this.signalStrengthWcdma));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".cellIdentityWcdma = ");
        builder.append(this.cellIdentityWcdma);
        builder.append(", .signalStrengthWcdma = ");
        builder.append(this.signalStrengthWcdma);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(96L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CellInfoWcdma> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfoWcdma> _hidl_vec = new ArrayList<CellInfoWcdma>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 96, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfoWcdma _hidl_vec_element = new CellInfoWcdma();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 96);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.cellIdentityWcdma.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.signalStrengthWcdma.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 80L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(96);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfoWcdma> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 96);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 96);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.cellIdentityWcdma.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.signalStrengthWcdma.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 80L);
    }
}

