/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_3;

import android.hardware.radio.V1_0.CdmaCallWaiting;
import android.hardware.radio.V1_0.CdmaInformationRecords;
import android.hardware.radio.V1_0.CdmaSignalInfoRecord;
import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.HardwareConfig;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.PcoDataInfo;
import android.hardware.radio.V1_0.RadioCapability;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.SimRefreshResult;
import android.hardware.radio.V1_0.StkCcUnsolSsResult;
import android.hardware.radio.V1_0.SuppSvcNotification;
import android.hardware.radio.V1_1.KeepaliveStatus;
import android.hardware.radio.V1_1.NetworkScanResult;
import android.hardware.radio.V1_2.LinkCapacityEstimate;
import android.hardware.radio.V1_2.PhysicalChannelConfig;
import android.hardware.radio.V1_2.SignalStrength;
import android.internal.hidl.base.V1_0.DebugInfo;
import android.os.HidlSupport;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.NativeHandle;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface IRadioIndication
extends android.hardware.radio.V1_2.IRadioIndication {
    public static final String kInterfaceName = "android.hardware.radio@1.3::IRadioIndication";

    public static IRadioIndication asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof IRadioIndication) {
            return (IRadioIndication)iface;
        }
        Proxy proxy = new Proxy(binder);
        try {
            for (String descriptor : proxy.interfaceChain()) {
                if (!descriptor.equals(kInterfaceName)) continue;
                return proxy;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static IRadioIndication castFrom(IHwInterface iface) {
        return iface == null ? null : IRadioIndication.asInterface(iface.asBinder());
    }

    @Override
    public IHwBinder asBinder();

    public static IRadioIndication getService(String serviceName, boolean retry) throws RemoteException {
        return IRadioIndication.asInterface(HwBinder.getService(kInterfaceName, serviceName, retry));
    }

    public static IRadioIndication getService(boolean retry) throws RemoteException {
        return IRadioIndication.getService("default", retry);
    }

    public static IRadioIndication getService(String serviceName) throws RemoteException {
        return IRadioIndication.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static IRadioIndication getService() throws RemoteException {
        return IRadioIndication.getService("default");
    }

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public void debug(NativeHandle var1, ArrayList<String> var2) throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public ArrayList<byte[]> getHashChain() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements IRadioIndication {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(IRadioIndication.kInterfaceName, "android.hardware.radio@1.2::IRadioIndication", "android.hardware.radio@1.1::IRadioIndication", "android.hardware.radio@1.0::IRadioIndication", "android.hidl.base@1.0::IBase"));
        }

        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) {
        }

        @Override
        public final String interfaceDescriptor() {
            return IRadioIndication.kInterfaceName;
        }

        @Override
        public final ArrayList<byte[]> getHashChain() {
            return new ArrayList<byte[]>(Arrays.asList({-23, -48, -15, 26, 82, 113, 95, 90, 41, -40, -98, 45, -114, 46, 33, -37, 30, 22, -92, 49, 116, -81, 107, -99, 81, -90, 45, 112, 92, -38, 20, 85}, {-51, -89, 82, -82, -85, -86, -68, 32, 72, 106, -126, -84, 87, -93, -35, 16, 119, -123, -64, 6, 9, 74, 52, -101, -59, -30, 36, -24, -86, 34, -95, 124}, {-4, -59, -56, -56, -117, -123, -87, -10, 63, -70, 103, -39, -26, 116, -38, 70, 108, 114, -87, -116, -94, -121, -13, 67, -5, 87, 33, -48, -104, 113, 63, -122}, {92, -114, -5, -71, -60, 81, -91, -105, 55, -19, 44, 108, 32, 35, 10, -82, 71, 69, -125, -100, -96, 29, -128, -120, -42, -36, -55, 2, 14, 82, -46, -59}, {-20, 127, -41, -98, -48, 45, -6, -123, -68, 73, -108, 38, -83, -82, 62, -66, 35, -17, 5, 36, -13, -51, 105, 87, 19, -109, 36, -72, 59, 24, -54, 76}));
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = HidlSupport.getPidIfSharable();
            info.ptr = 0L;
            info.arch = 0;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            HwBinder.enableInstrumentation();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (IRadioIndication.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(serviceName);
        }

        public String toString() {
            return this.interfaceDescriptor() + "@Stub";
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int radioState = _hidl_request.readInt32();
                    this.radioStateChanged(type, radioState);
                    break;
                }
                case 2: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.callStateChanged(type);
                    break;
                }
                case 3: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.networkStateChanged(type);
                    break;
                }
                case 4: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<Byte> pdu = _hidl_request.readInt8Vector();
                    this.newSms(type, pdu);
                    break;
                }
                case 5: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<Byte> pdu = _hidl_request.readInt8Vector();
                    this.newSmsStatusReport(type, pdu);
                    break;
                }
                case 6: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int recordNumber = _hidl_request.readInt32();
                    this.newSmsOnSim(type, recordNumber);
                    break;
                }
                case 7: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int modeType = _hidl_request.readInt32();
                    String msg = _hidl_request.readString();
                    this.onUssd(type, modeType, msg);
                    break;
                }
                case 8: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    String nitzTime = _hidl_request.readString();
                    long receivedTime = _hidl_request.readInt64();
                    this.nitzTimeReceived(type, nitzTime, receivedTime);
                    break;
                }
                case 9: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    android.hardware.radio.V1_0.SignalStrength signalStrength = new android.hardware.radio.V1_0.SignalStrength();
                    signalStrength.readFromParcel(_hidl_request);
                    this.currentSignalStrength(type, signalStrength);
                    break;
                }
                case 10: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<SetupDataCallResult> dcList = SetupDataCallResult.readVectorFromParcel(_hidl_request);
                    this.dataCallListChanged(type, dcList);
                    break;
                }
                case 11: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    SuppSvcNotification suppSvc = new SuppSvcNotification();
                    suppSvc.readFromParcel(_hidl_request);
                    this.suppSvcNotify(type, suppSvc);
                    break;
                }
                case 12: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.stkSessionEnd(type);
                    break;
                }
                case 13: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    String cmd = _hidl_request.readString();
                    this.stkProactiveCommand(type, cmd);
                    break;
                }
                case 14: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    String cmd = _hidl_request.readString();
                    this.stkEventNotify(type, cmd);
                    break;
                }
                case 15: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    long timeout = _hidl_request.readInt64();
                    this.stkCallSetup(type, timeout);
                    break;
                }
                case 16: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.simSmsStorageFull(type);
                    break;
                }
                case 17: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    SimRefreshResult refreshResult = new SimRefreshResult();
                    refreshResult.readFromParcel(_hidl_request);
                    this.simRefresh(type, refreshResult);
                    break;
                }
                case 18: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    boolean isGsm = _hidl_request.readBool();
                    CdmaSignalInfoRecord record = new CdmaSignalInfoRecord();
                    record.readFromParcel(_hidl_request);
                    this.callRing(type, isGsm, record);
                    break;
                }
                case 19: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.simStatusChanged(type);
                    break;
                }
                case 20: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    CdmaSmsMessage msg = new CdmaSmsMessage();
                    msg.readFromParcel(_hidl_request);
                    this.cdmaNewSms(type, msg);
                    break;
                }
                case 21: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<Byte> data = _hidl_request.readInt8Vector();
                    this.newBroadcastSms(type, data);
                    break;
                }
                case 22: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.cdmaRuimSmsStorageFull(type);
                    break;
                }
                case 23: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int state = _hidl_request.readInt32();
                    this.restrictedStateChanged(type, state);
                    break;
                }
                case 24: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.enterEmergencyCallbackMode(type);
                    break;
                }
                case 25: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    CdmaCallWaiting callWaitingRecord = new CdmaCallWaiting();
                    callWaitingRecord.readFromParcel(_hidl_request);
                    this.cdmaCallWaiting(type, callWaitingRecord);
                    break;
                }
                case 26: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int status = _hidl_request.readInt32();
                    this.cdmaOtaProvisionStatus(type, status);
                    break;
                }
                case 27: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    CdmaInformationRecords records = new CdmaInformationRecords();
                    records.readFromParcel(_hidl_request);
                    this.cdmaInfoRec(type, records);
                    break;
                }
                case 28: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    boolean start = _hidl_request.readBool();
                    this.indicateRingbackTone(type, start);
                    break;
                }
                case 29: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.resendIncallMute(type);
                    break;
                }
                case 30: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int cdmaSource = _hidl_request.readInt32();
                    this.cdmaSubscriptionSourceChanged(type, cdmaSource);
                    break;
                }
                case 31: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int version = _hidl_request.readInt32();
                    this.cdmaPrlChanged(type, version);
                    break;
                }
                case 32: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.exitEmergencyCallbackMode(type);
                    break;
                }
                case 33: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.rilConnected(type);
                    break;
                }
                case 34: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int rat = _hidl_request.readInt32();
                    this.voiceRadioTechChanged(type, rat);
                    break;
                }
                case 35: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<CellInfo> records = CellInfo.readVectorFromParcel(_hidl_request);
                    this.cellInfoList(type, records);
                    break;
                }
                case 36: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    this.imsNetworkStateChanged(type);
                    break;
                }
                case 37: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    boolean activate = _hidl_request.readBool();
                    this.subscriptionStatusChanged(type, activate);
                    break;
                }
                case 38: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    int state = _hidl_request.readInt32();
                    this.srvccStateNotify(type, state);
                    break;
                }
                case 39: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<HardwareConfig> configs = HardwareConfig.readVectorFromParcel(_hidl_request);
                    this.hardwareConfigChanged(type, configs);
                    break;
                }
                case 40: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    RadioCapability rc = new RadioCapability();
                    rc.readFromParcel(_hidl_request);
                    this.radioCapabilityIndication(type, rc);
                    break;
                }
                case 41: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    StkCcUnsolSsResult ss = new StkCcUnsolSsResult();
                    ss.readFromParcel(_hidl_request);
                    this.onSupplementaryServiceIndication(type, ss);
                    break;
                }
                case 42: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    String alpha = _hidl_request.readString();
                    this.stkCallControlAlphaNotify(type, alpha);
                    break;
                }
                case 43: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    LceDataInfo lce = new LceDataInfo();
                    lce.readFromParcel(_hidl_request);
                    this.lceData(type, lce);
                    break;
                }
                case 44: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    PcoDataInfo pco = new PcoDataInfo();
                    pco.readFromParcel(_hidl_request);
                    this.pcoData(type, pco);
                    break;
                }
                case 45: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.0::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    String reason = _hidl_request.readString();
                    this.modemReset(type, reason);
                    break;
                }
                case 46: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.1::IRadioIndication");
                    int info = _hidl_request.readInt32();
                    this.carrierInfoForImsiEncryption(info);
                    break;
                }
                case 47: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.1::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    NetworkScanResult result = new NetworkScanResult();
                    result.readFromParcel(_hidl_request);
                    this.networkScanResult(type, result);
                    break;
                }
                case 48: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.1::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    KeepaliveStatus status = new KeepaliveStatus();
                    status.readFromParcel(_hidl_request);
                    this.keepaliveStatus(type, status);
                    break;
                }
                case 49: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.2::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    android.hardware.radio.V1_2.NetworkScanResult result = new android.hardware.radio.V1_2.NetworkScanResult();
                    result.readFromParcel(_hidl_request);
                    this.networkScanResult_1_2(type, result);
                    break;
                }
                case 50: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.2::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<android.hardware.radio.V1_2.CellInfo> records = android.hardware.radio.V1_2.CellInfo.readVectorFromParcel(_hidl_request);
                    this.cellInfoList_1_2(type, records);
                    break;
                }
                case 51: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.2::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    LinkCapacityEstimate lce = new LinkCapacityEstimate();
                    lce.readFromParcel(_hidl_request);
                    this.currentLinkCapacityEstimate(type, lce);
                    break;
                }
                case 52: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.2::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    ArrayList<PhysicalChannelConfig> configs = PhysicalChannelConfig.readVectorFromParcel(_hidl_request);
                    this.currentPhysicalChannelConfigs(type, configs);
                    break;
                }
                case 53: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.radio@1.2::IRadioIndication");
                    int type = _hidl_request.readInt32();
                    SignalStrength signalStrength = new SignalStrength();
                    signalStrength.readFromParcel(_hidl_request);
                    this.currentSignalStrength_1_2(type, signalStrength);
                    break;
                }
                case 256067662: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    NativeHandle fd = _hidl_request.readNativeHandle();
                    ArrayList<String> options = _hidl_request.readStringVector();
                    this.debug(fd, options);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256398152: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<byte[]> _hidl_out_hashchain = this.getHashChain();
                    _hidl_reply.writeStatus(0);
                    HwBlob _hidl_blob = new HwBlob(16);
                    int _hidl_vec_size = _hidl_out_hashchain.size();
                    _hidl_blob.putInt32(8L, _hidl_vec_size);
                    _hidl_blob.putBool(12L, false);
                    HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
                    for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                        long _hidl_array_offset_1 = _hidl_index_0 * 32;
                        byte[] _hidl_array_item_1 = _hidl_out_hashchain.get(_hidl_index_0);
                        if (_hidl_array_item_1 == null || _hidl_array_item_1.length != 32) {
                            throw new IllegalArgumentException("Array element is not of the expected length");
                        }
                        childBlob.putInt8Array(_hidl_array_offset_1, _hidl_array_item_1);
                        _hidl_array_offset_1 += 32L;
                    }
                    _hidl_blob.putBlob(0L, childBlob);
                    _hidl_reply.writeBuffer(_hidl_blob);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
                case 256921159: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.ping();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 257049926: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
                case 0xF555444: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements IRadioIndication {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        public String toString() {
            try {
                return this.interfaceDescriptor() + "@Proxy";
            }
            catch (RemoteException remoteException) {
                return "[class or subclass of android.hardware.radio@1.3::IRadioIndication]@Proxy";
            }
        }

        public final boolean equals(Object other) {
            return HidlSupport.interfacesEqual(this, other);
        }

        public final int hashCode() {
            return this.asBinder().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void radioStateChanged(int type, int radioState) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(radioState);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(1, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callStateChanged(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(2, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void networkStateChanged(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(3, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newSms(int type, ArrayList<Byte> pdu) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt8Vector(pdu);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(4, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newSmsStatusReport(int type, ArrayList<Byte> pdu) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt8Vector(pdu);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(5, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newSmsOnSim(int type, int recordNumber) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(recordNumber);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(6, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUssd(int type, int modeType, String msg) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(modeType);
            _hidl_request.writeString(msg);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(7, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nitzTimeReceived(int type, String nitzTime, long receivedTime) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeString(nitzTime);
            _hidl_request.writeInt64(receivedTime);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(8, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentSignalStrength(int type, android.hardware.radio.V1_0.SignalStrength signalStrength) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            signalStrength.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(9, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataCallListChanged(int type, ArrayList<SetupDataCallResult> dcList) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            SetupDataCallResult.writeVectorToParcel(_hidl_request, dcList);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(10, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void suppSvcNotify(int type, SuppSvcNotification suppSvc) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            suppSvc.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(11, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stkSessionEnd(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(12, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stkProactiveCommand(int type, String cmd) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeString(cmd);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(13, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stkEventNotify(int type, String cmd) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeString(cmd);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(14, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stkCallSetup(int type, long timeout) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt64(timeout);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(15, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void simSmsStorageFull(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(16, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void simRefresh(int type, SimRefreshResult refreshResult) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            refreshResult.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(17, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callRing(int type, boolean isGsm, CdmaSignalInfoRecord record) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeBool(isGsm);
            record.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(18, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void simStatusChanged(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(19, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaNewSms(int type, CdmaSmsMessage msg) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            msg.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(20, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newBroadcastSms(int type, ArrayList<Byte> data) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt8Vector(data);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(21, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaRuimSmsStorageFull(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(22, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restrictedStateChanged(int type, int state) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(state);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(23, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterEmergencyCallbackMode(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(24, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaCallWaiting(int type, CdmaCallWaiting callWaitingRecord) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            callWaitingRecord.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(25, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaOtaProvisionStatus(int type, int status) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(status);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(26, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaInfoRec(int type, CdmaInformationRecords records) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            records.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(27, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void indicateRingbackTone(int type, boolean start) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeBool(start);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(28, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resendIncallMute(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(29, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaSubscriptionSourceChanged(int type, int cdmaSource) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(cdmaSource);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(30, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cdmaPrlChanged(int type, int version) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(version);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(31, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exitEmergencyCallbackMode(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(32, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rilConnected(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(33, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void voiceRadioTechChanged(int type, int rat) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(rat);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(34, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cellInfoList(int type, ArrayList<CellInfo> records) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            CellInfo.writeVectorToParcel(_hidl_request, records);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(35, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsNetworkStateChanged(int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(36, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void subscriptionStatusChanged(int type, boolean activate) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeBool(activate);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(37, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void srvccStateNotify(int type, int state) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt32(state);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(38, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hardwareConfigChanged(int type, ArrayList<HardwareConfig> configs) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            HardwareConfig.writeVectorToParcel(_hidl_request, configs);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(39, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void radioCapabilityIndication(int type, RadioCapability rc) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            rc.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(40, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSupplementaryServiceIndication(int type, StkCcUnsolSsResult ss) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            ss.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(41, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stkCallControlAlphaNotify(int type, String alpha) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeString(alpha);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(42, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lceData(int type, LceDataInfo lce) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            lce.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(43, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pcoData(int type, PcoDataInfo pco) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            pco.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(44, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modemReset(int type, String reason) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.0::IRadioIndication");
            _hidl_request.writeInt32(type);
            _hidl_request.writeString(reason);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(45, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void carrierInfoForImsiEncryption(int info) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.1::IRadioIndication");
            _hidl_request.writeInt32(info);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(46, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void networkScanResult(int type, NetworkScanResult result) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.1::IRadioIndication");
            _hidl_request.writeInt32(type);
            result.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(47, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keepaliveStatus(int type, KeepaliveStatus status) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.1::IRadioIndication");
            _hidl_request.writeInt32(type);
            status.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(48, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void networkScanResult_1_2(int type, android.hardware.radio.V1_2.NetworkScanResult result) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.2::IRadioIndication");
            _hidl_request.writeInt32(type);
            result.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(49, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cellInfoList_1_2(int type, ArrayList<android.hardware.radio.V1_2.CellInfo> records) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.2::IRadioIndication");
            _hidl_request.writeInt32(type);
            android.hardware.radio.V1_2.CellInfo.writeVectorToParcel(_hidl_request, records);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(50, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentLinkCapacityEstimate(int type, LinkCapacityEstimate lce) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.2::IRadioIndication");
            _hidl_request.writeInt32(type);
            lce.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(51, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentPhysicalChannelConfigs(int type, ArrayList<PhysicalChannelConfig> configs) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.2::IRadioIndication");
            _hidl_request.writeInt32(type);
            PhysicalChannelConfig.writeVectorToParcel(_hidl_request, configs);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(52, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentSignalStrength_1_2(int type, SignalStrength signalStrength) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.radio@1.2::IRadioIndication");
            _hidl_request.writeInt32(type);
            signalStrength.writeToParcel(_hidl_request);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(53, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                ArrayList<String> _hidl_out_descriptors;
                this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<String> arrayList = _hidl_out_descriptors = _hidl_reply.readStringVector();
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            _hidl_request.writeNativeHandle(fd);
            _hidl_request.writeStringVector(options);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256131655, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                String _hidl_out_descriptor;
                this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                String string2 = _hidl_out_descriptor = _hidl_reply.readString();
                return string2;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<byte[]> getHashChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256398152, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<byte[]> _hidl_out_hashchain = new ArrayList<byte[]>();
                HwBlob _hidl_blob = _hidl_reply.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = _hidl_reply.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
                _hidl_out_hashchain.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    byte[] _hidl_vec_element = new byte[32];
                    long _hidl_array_offset_1 = _hidl_index_0 * 32;
                    childBlob.copyToInt8Array(_hidl_array_offset_1, _hidl_vec_element, 32);
                    _hidl_array_offset_1 += 32L;
                    _hidl_out_hashchain.add(_hidl_vec_element);
                }
                ArrayList<byte[]> arrayList = _hidl_out_hashchain;
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                DebugInfo _hidl_out_info = new DebugInfo();
                _hidl_out_info.readFromParcel(_hidl_reply);
                DebugInfo debugInfo = _hidl_out_info;
                return debugInfo;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }
}

