/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_3;

import android.hardware.radio.V1_0.RadioError;
import android.hardware.radio.V1_0.RadioResponseType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class RadioResponseInfoModem {
    public int type;
    public int serial;
    public int error;
    public boolean isEnabled;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != RadioResponseInfoModem.class) {
            return false;
        }
        RadioResponseInfoModem other = (RadioResponseInfoModem)otherObject;
        if (this.type != other.type) {
            return false;
        }
        if (this.serial != other.serial) {
            return false;
        }
        if (this.error != other.error) {
            return false;
        }
        return this.isEnabled == other.isEnabled;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.serial), HidlSupport.deepHashCode(this.error), HidlSupport.deepHashCode(this.isEnabled));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".type = ");
        builder.append(RadioResponseType.toString(this.type));
        builder.append(", .serial = ");
        builder.append(this.serial);
        builder.append(", .error = ");
        builder.append(RadioError.toString(this.error));
        builder.append(", .isEnabled = ");
        builder.append(this.isEnabled);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(16L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<RadioResponseInfoModem> readVectorFromParcel(HwParcel parcel) {
        ArrayList<RadioResponseInfoModem> _hidl_vec = new ArrayList<RadioResponseInfoModem>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            RadioResponseInfoModem _hidl_vec_element = new RadioResponseInfoModem();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.type = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.serial = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.error = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.isEnabled = _hidl_blob.getBool(_hidl_offset + 12L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(16);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<RadioResponseInfoModem> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.type);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.serial);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.error);
        _hidl_blob.putBool(_hidl_offset + 12L, this.isEnabled);
    }
}

