/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import android.hardware.radio.V1_4.EmergencyNumberSource;
import android.hardware.radio.V1_4.EmergencyServiceCategory;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class EmergencyNumber {
    public String number = new String();
    public String mcc = new String();
    public String mnc = new String();
    public int categories;
    public ArrayList<String> urns = new ArrayList();
    public int sources;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != EmergencyNumber.class) {
            return false;
        }
        EmergencyNumber other = (EmergencyNumber)otherObject;
        if (!HidlSupport.deepEquals(this.number, other.number)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.mcc, other.mcc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.mnc, other.mnc)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.categories, other.categories)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.urns, other.urns)) {
            return false;
        }
        return HidlSupport.deepEquals(this.sources, other.sources);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.number), HidlSupport.deepHashCode(this.mcc), HidlSupport.deepHashCode(this.mnc), HidlSupport.deepHashCode(this.categories), HidlSupport.deepHashCode(this.urns), HidlSupport.deepHashCode(this.sources));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".number = ");
        builder.append(this.number);
        builder.append(", .mcc = ");
        builder.append(this.mcc);
        builder.append(", .mnc = ");
        builder.append(this.mnc);
        builder.append(", .categories = ");
        builder.append(EmergencyServiceCategory.dumpBitfield(this.categories));
        builder.append(", .urns = ");
        builder.append(this.urns);
        builder.append(", .sources = ");
        builder.append(EmergencyNumberSource.dumpBitfield(this.sources));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(80L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<EmergencyNumber> readVectorFromParcel(HwParcel parcel) {
        ArrayList<EmergencyNumber> _hidl_vec = new ArrayList<EmergencyNumber>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 80, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            EmergencyNumber _hidl_vec_element = new EmergencyNumber();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 80);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.number = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.number.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.mcc = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.mcc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.mnc = _hidl_blob.getString(_hidl_offset + 32L);
        parcel.readEmbeddedBuffer(this.mnc.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, false);
        this.categories = _hidl_blob.getInt32(_hidl_offset + 48L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 56L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 16, _hidl_blob.handle(), _hidl_offset + 56L + 0L, true);
        this.urns.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            String _hidl_vec_element = new String();
            _hidl_vec_element = childBlob.getString(_hidl_index_0 * 16);
            parcel.readEmbeddedBuffer(_hidl_vec_element.getBytes().length + 1, childBlob.handle(), _hidl_index_0 * 16 + 0, false);
            this.urns.add(_hidl_vec_element);
        }
        this.sources = _hidl_blob.getInt32(_hidl_offset + 72L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(80);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<EmergencyNumber> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 80);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 80);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.number);
        _hidl_blob.putString(_hidl_offset + 16L, this.mcc);
        _hidl_blob.putString(_hidl_offset + 32L, this.mnc);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.categories);
        int _hidl_vec_size = this.urns.size();
        _hidl_blob.putInt32(_hidl_offset + 56L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 56L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putString(_hidl_index_0 * 16, this.urns.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 56L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 72L, this.sources);
    }
}

