/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import android.hardware.radio.V1_4.RadioFrequencyInfo;
import android.hardware.radio.V1_4.RadioTechnology;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class PhysicalChannelConfig {
    public android.hardware.radio.V1_2.PhysicalChannelConfig base = new android.hardware.radio.V1_2.PhysicalChannelConfig();
    public int rat;
    public RadioFrequencyInfo rfInfo = new RadioFrequencyInfo();
    public ArrayList<Integer> contextIds = new ArrayList();
    public int physicalCellId;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != PhysicalChannelConfig.class) {
            return false;
        }
        PhysicalChannelConfig other = (PhysicalChannelConfig)otherObject;
        if (!HidlSupport.deepEquals(this.base, other.base)) {
            return false;
        }
        if (this.rat != other.rat) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.rfInfo, other.rfInfo)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.contextIds, other.contextIds)) {
            return false;
        }
        return this.physicalCellId == other.physicalCellId;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.base), HidlSupport.deepHashCode(this.rat), HidlSupport.deepHashCode(this.rfInfo), HidlSupport.deepHashCode(this.contextIds), HidlSupport.deepHashCode(this.physicalCellId));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".base = ");
        builder.append(this.base);
        builder.append(", .rat = ");
        builder.append(RadioTechnology.toString(this.rat));
        builder.append(", .rfInfo = ");
        builder.append(this.rfInfo);
        builder.append(", .contextIds = ");
        builder.append(this.contextIds);
        builder.append(", .physicalCellId = ");
        builder.append(this.physicalCellId);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<PhysicalChannelConfig> readVectorFromParcel(HwParcel parcel) {
        ArrayList<PhysicalChannelConfig> _hidl_vec = new ArrayList<PhysicalChannelConfig>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            PhysicalChannelConfig _hidl_vec_element = new PhysicalChannelConfig();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.base.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.rat = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.rfInfo.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 12L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 24L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), _hidl_offset + 24L + 0L, true);
        this.contextIds.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            int _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
            this.contextIds.add(_hidl_vec_element);
        }
        this.physicalCellId = _hidl_blob.getInt32(_hidl_offset + 40L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<PhysicalChannelConfig> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.base.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.rat);
        this.rfInfo.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 12L);
        int _hidl_vec_size = this.contextIds.size();
        _hidl_blob.putInt32(_hidl_offset + 24L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 24L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 4);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt32(_hidl_index_0 * 4, this.contextIds.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 24L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 40L, this.physicalCellId);
    }
}

