/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import android.hardware.radio.V1_0.RadioCapabilityPhase;
import android.hardware.radio.V1_0.RadioCapabilityStatus;
import android.hardware.radio.V1_4.RadioAccessFamily;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class RadioCapability {
    public int session;
    public int phase;
    public int raf;
    public String logicalModemUuid = new String();
    public int status;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != RadioCapability.class) {
            return false;
        }
        RadioCapability other = (RadioCapability)otherObject;
        if (this.session != other.session) {
            return false;
        }
        if (this.phase != other.phase) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.raf, other.raf)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.logicalModemUuid, other.logicalModemUuid)) {
            return false;
        }
        return this.status == other.status;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.session), HidlSupport.deepHashCode(this.phase), HidlSupport.deepHashCode(this.raf), HidlSupport.deepHashCode(this.logicalModemUuid), HidlSupport.deepHashCode(this.status));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".session = ");
        builder.append(this.session);
        builder.append(", .phase = ");
        builder.append(RadioCapabilityPhase.toString(this.phase));
        builder.append(", .raf = ");
        builder.append(RadioAccessFamily.dumpBitfield(this.raf));
        builder.append(", .logicalModemUuid = ");
        builder.append(this.logicalModemUuid);
        builder.append(", .status = ");
        builder.append(RadioCapabilityStatus.toString(this.status));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<RadioCapability> readVectorFromParcel(HwParcel parcel) {
        ArrayList<RadioCapability> _hidl_vec = new ArrayList<RadioCapability>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            RadioCapability _hidl_vec_element = new RadioCapability();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.session = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.phase = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.raf = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.logicalModemUuid = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.logicalModemUuid.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.status = _hidl_blob.getInt32(_hidl_offset + 32L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<RadioCapability> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.session);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.phase);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.raf);
        _hidl_blob.putString(_hidl_offset + 16L, this.logicalModemUuid);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.status);
    }
}

