/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.config.V1_0;

import android.hardware.radio.V1_0.CardState;
import android.hardware.radio.config.V1_0.SlotState;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class SimSlotStatus {
    public int cardState;
    public int slotState;
    public String atr = new String();
    public int logicalSlotId;
    public String iccid = new String();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != SimSlotStatus.class) {
            return false;
        }
        SimSlotStatus other = (SimSlotStatus)otherObject;
        if (this.cardState != other.cardState) {
            return false;
        }
        if (this.slotState != other.slotState) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.atr, other.atr)) {
            return false;
        }
        if (this.logicalSlotId != other.logicalSlotId) {
            return false;
        }
        return HidlSupport.deepEquals(this.iccid, other.iccid);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.cardState), HidlSupport.deepHashCode(this.slotState), HidlSupport.deepHashCode(this.atr), HidlSupport.deepHashCode(this.logicalSlotId), HidlSupport.deepHashCode(this.iccid));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".cardState = ");
        builder.append(CardState.toString(this.cardState));
        builder.append(", .slotState = ");
        builder.append(SlotState.toString(this.slotState));
        builder.append(", .atr = ");
        builder.append(this.atr);
        builder.append(", .logicalSlotId = ");
        builder.append(this.logicalSlotId);
        builder.append(", .iccid = ");
        builder.append(this.iccid);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(48L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<SimSlotStatus> readVectorFromParcel(HwParcel parcel) {
        ArrayList<SimSlotStatus> _hidl_vec = new ArrayList<SimSlotStatus>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 48, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            SimSlotStatus _hidl_vec_element = new SimSlotStatus();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.cardState = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.slotState = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.atr = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.atr.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.logicalSlotId = _hidl_blob.getInt32(_hidl_offset + 24L);
        this.iccid = _hidl_blob.getString(_hidl_offset + 32L);
        parcel.readEmbeddedBuffer(this.iccid.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, false);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<SimSlotStatus> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.cardState);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.slotState);
        _hidl_blob.putString(_hidl_offset + 8L, this.atr);
        _hidl_blob.putInt32(_hidl_offset + 24L, this.logicalSlotId);
        _hidl_blob.putString(_hidl_offset + 32L, this.iccid);
    }
}

