/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.config.V1_1;

import android.hardware.radio.config.V1_1.ModemInfo;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class PhoneCapability {
    public byte maxActiveData;
    public byte maxActiveInternetData;
    public boolean isInternetLingeringSupported;
    public ArrayList<ModemInfo> logicalModemList = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != PhoneCapability.class) {
            return false;
        }
        PhoneCapability other = (PhoneCapability)otherObject;
        if (this.maxActiveData != other.maxActiveData) {
            return false;
        }
        if (this.maxActiveInternetData != other.maxActiveInternetData) {
            return false;
        }
        if (this.isInternetLingeringSupported != other.isInternetLingeringSupported) {
            return false;
        }
        return HidlSupport.deepEquals(this.logicalModemList, other.logicalModemList);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.maxActiveData), HidlSupport.deepHashCode(this.maxActiveInternetData), HidlSupport.deepHashCode(this.isInternetLingeringSupported), HidlSupport.deepHashCode(this.logicalModemList));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".maxActiveData = ");
        builder.append(this.maxActiveData);
        builder.append(", .maxActiveInternetData = ");
        builder.append(this.maxActiveInternetData);
        builder.append(", .isInternetLingeringSupported = ");
        builder.append(this.isInternetLingeringSupported);
        builder.append(", .logicalModemList = ");
        builder.append(this.logicalModemList);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<PhoneCapability> readVectorFromParcel(HwParcel parcel) {
        ArrayList<PhoneCapability> _hidl_vec = new ArrayList<PhoneCapability>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            PhoneCapability _hidl_vec_element = new PhoneCapability();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.maxActiveData = _hidl_blob.getInt8(_hidl_offset + 0L);
        this.maxActiveInternetData = _hidl_blob.getInt8(_hidl_offset + 1L);
        this.isInternetLingeringSupported = _hidl_blob.getBool(_hidl_offset + 2L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 8L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, true);
        this.logicalModemList.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            ModemInfo _hidl_vec_element = new ModemInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 1);
            this.logicalModemList.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<PhoneCapability> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt8(_hidl_offset + 0L, this.maxActiveData);
        _hidl_blob.putInt8(_hidl_offset + 1L, this.maxActiveInternetData);
        _hidl_blob.putBool(_hidl_offset + 2L, this.isInternetLingeringSupported);
        int _hidl_vec_size = this.logicalModemList.size();
        _hidl_blob.putInt32(_hidl_offset + 8L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 8L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.logicalModemList.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 1);
        }
        _hidl_blob.putBlob(_hidl_offset + 8L + 0L, childBlob);
    }
}

