/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.tetheroffload.control.V1_0;

import android.hardware.tetheroffload.control.V1_0.ITetheringOffloadCallback;
import android.hidl.base.V1_0.DebugInfo;
import android.hidl.base.V1_0.IBase;
import android.os.HidlSupport;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.NativeHandle;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface IOffloadControl
extends IBase {
    public static final String kInterfaceName = "android.hardware.tetheroffload.control@1.0::IOffloadControl";

    public static IOffloadControl asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof IOffloadControl) {
            return (IOffloadControl)iface;
        }
        Proxy proxy = new Proxy(binder);
        for (String descriptor : proxy.interfaceChain()) {
            if (descriptor.equals(kInterfaceName)) {
                return proxy;
            }
            try {
            }
            catch (RemoteException remoteException) {
                // empty catch block
                break;
            }
        }
        return null;
    }

    public static IOffloadControl castFrom(IHwInterface iface) {
        return iface == null ? null : IOffloadControl.asInterface(iface.asBinder());
    }

    @Override
    public IHwBinder asBinder();

    public static IOffloadControl getService(String serviceName, boolean retry) throws RemoteException {
        return IOffloadControl.asInterface(HwBinder.getService(kInterfaceName, serviceName, retry));
    }

    public static IOffloadControl getService(boolean retry) throws RemoteException {
        return IOffloadControl.getService("default", retry);
    }

    public static IOffloadControl getService(String serviceName) throws RemoteException {
        return IOffloadControl.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static IOffloadControl getService() throws RemoteException {
        return IOffloadControl.getService("default");
    }

    public void initOffload(ITetheringOffloadCallback var1, initOffloadCallback var2) throws RemoteException;

    public void stopOffload(stopOffloadCallback var1) throws RemoteException;

    public void setLocalPrefixes(ArrayList<String> var1, setLocalPrefixesCallback var2) throws RemoteException;

    public void getForwardedStats(String var1, getForwardedStatsCallback var2) throws RemoteException;

    public void setDataLimit(String var1, long var2, setDataLimitCallback var4) throws RemoteException;

    public void setUpstreamParameters(String var1, String var2, String var3, ArrayList<String> var4, setUpstreamParametersCallback var5) throws RemoteException;

    public void addDownstream(String var1, String var2, addDownstreamCallback var3) throws RemoteException;

    public void removeDownstream(String var1, String var2, removeDownstreamCallback var3) throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public void debug(NativeHandle var1, ArrayList<String> var2) throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public ArrayList<byte[]> getHashChain() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements IOffloadControl {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(IOffloadControl.kInterfaceName, "android.hidl.base@1.0::IBase"));
        }

        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) {
        }

        @Override
        public final String interfaceDescriptor() {
            return IOffloadControl.kInterfaceName;
        }

        @Override
        public final ArrayList<byte[]> getHashChain() {
            return new ArrayList<byte[]>(Arrays.asList({68, 123, 0, 48, 107, -55, 90, 122, -81, -20, 29, 102, 15, 111, 62, -97, 118, -84, -117, -64, 53, 49, -109, 67, 94, 85, 121, -85, -125, 61, -90, 25}, {-20, 127, -41, -98, -48, 45, -6, -123, -68, 73, -108, 38, -83, -82, 62, -66, 35, -17, 5, 36, -13, -51, 105, 87, 19, -109, 36, -72, 59, 24, -54, 76}));
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = HidlSupport.getPidIfSharable();
            info.ptr = 0L;
            info.arch = 0;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            HwBinder.enableInstrumentation();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (IOffloadControl.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(serviceName);
        }

        public String toString() {
            return this.interfaceDescriptor() + "@Stub";
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, final HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    ITetheringOffloadCallback cb = ITetheringOffloadCallback.asInterface(_hidl_request.readStrongBinder());
                    this.initOffload(cb, new initOffloadCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 2: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    this.stopOffload(new stopOffloadCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 3: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    ArrayList<String> prefixes = _hidl_request.readStringVector();
                    this.setLocalPrefixes(prefixes, new setLocalPrefixesCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 4: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    String upstream = _hidl_request.readString();
                    this.getForwardedStats(upstream, new getForwardedStatsCallback(){

                        @Override
                        public void onValues(long rxBytes, long txBytes) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeInt64(rxBytes);
                            _hidl_reply.writeInt64(txBytes);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 5: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    String upstream = _hidl_request.readString();
                    long limit = _hidl_request.readInt64();
                    this.setDataLimit(upstream, limit, new setDataLimitCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 6: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    String iface = _hidl_request.readString();
                    String v4Addr = _hidl_request.readString();
                    String v4Gw = _hidl_request.readString();
                    ArrayList<String> v6Gws = _hidl_request.readStringVector();
                    this.setUpstreamParameters(iface, v4Addr, v4Gw, v6Gws, new setUpstreamParametersCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 7: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    String iface = _hidl_request.readString();
                    String prefix = _hidl_request.readString();
                    this.addDownstream(iface, prefix, new addDownstreamCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 8: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IOffloadControl.kInterfaceName);
                    String iface = _hidl_request.readString();
                    String prefix = _hidl_request.readString();
                    this.removeDownstream(iface, prefix, new removeDownstreamCallback(){

                        @Override
                        public void onValues(boolean success, String errMsg) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeBool(success);
                            _hidl_reply.writeString(errMsg);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 256067662: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    NativeHandle fd = _hidl_request.readNativeHandle();
                    ArrayList<String> options = _hidl_request.readStringVector();
                    this.debug(fd, options);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256398152: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<byte[]> _hidl_out_hashchain = this.getHashChain();
                    _hidl_reply.writeStatus(0);
                    HwBlob _hidl_blob = new HwBlob(16);
                    int _hidl_vec_size = _hidl_out_hashchain.size();
                    _hidl_blob.putInt32(8L, _hidl_vec_size);
                    _hidl_blob.putBool(12L, false);
                    HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
                    for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                        long _hidl_array_offset_1 = _hidl_index_0 * 32;
                        byte[] _hidl_array_item_1 = _hidl_out_hashchain.get(_hidl_index_0);
                        if (_hidl_array_item_1 == null || _hidl_array_item_1.length != 32) {
                            throw new IllegalArgumentException("Array element is not of the expected length");
                        }
                        childBlob.putInt8Array(_hidl_array_offset_1, _hidl_array_item_1);
                        _hidl_array_offset_1 += 32L;
                    }
                    _hidl_blob.putBlob(0L, childBlob);
                    _hidl_reply.writeBuffer(_hidl_blob);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
                case 256921159: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.ping();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 257049926: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
                case 0xF555444: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements IOffloadControl {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        public String toString() {
            try {
                return this.interfaceDescriptor() + "@Proxy";
            }
            catch (RemoteException remoteException) {
                return "[class or subclass of android.hardware.tetheroffload.control@1.0::IOffloadControl]@Proxy";
            }
        }

        public final boolean equals(Object other) {
            return HidlSupport.interfacesEqual(this, other);
        }

        public final int hashCode() {
            return this.asBinder().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initOffload(ITetheringOffloadCallback cb, initOffloadCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeStrongBinder(cb == null ? null : cb.asBinder());
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopOffload(stopOffloadCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(2, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLocalPrefixes(ArrayList<String> prefixes, setLocalPrefixesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeStringVector(prefixes);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(3, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getForwardedStats(String upstream, getForwardedStatsCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeString(upstream);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(4, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                long _hidl_out_rxBytes = _hidl_reply.readInt64();
                long _hidl_out_txBytes = _hidl_reply.readInt64();
                _hidl_cb.onValues(_hidl_out_rxBytes, _hidl_out_txBytes);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDataLimit(String upstream, long limit, setDataLimitCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeString(upstream);
            _hidl_request.writeInt64(limit);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(5, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUpstreamParameters(String iface, String v4Addr, String v4Gw, ArrayList<String> v6Gws, setUpstreamParametersCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeString(iface);
            _hidl_request.writeString(v4Addr);
            _hidl_request.writeString(v4Gw);
            _hidl_request.writeStringVector(v6Gws);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(6, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addDownstream(String iface, String prefix, addDownstreamCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeString(iface);
            _hidl_request.writeString(prefix);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(7, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeDownstream(String iface, String prefix, removeDownstreamCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IOffloadControl.kInterfaceName);
            _hidl_request.writeString(iface);
            _hidl_request.writeString(prefix);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(8, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                boolean _hidl_out_success = _hidl_reply.readBool();
                String _hidl_out_errMsg = _hidl_reply.readString();
                _hidl_cb.onValues(_hidl_out_success, _hidl_out_errMsg);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                ArrayList<String> _hidl_out_descriptors;
                this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<String> arrayList = _hidl_out_descriptors = _hidl_reply.readStringVector();
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            _hidl_request.writeNativeHandle(fd);
            _hidl_request.writeStringVector(options);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256131655, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                String _hidl_out_descriptor;
                this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                String string2 = _hidl_out_descriptor = _hidl_reply.readString();
                return string2;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<byte[]> getHashChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256398152, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<byte[]> _hidl_out_hashchain = new ArrayList<byte[]>();
                HwBlob _hidl_blob = _hidl_reply.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = _hidl_reply.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
                _hidl_out_hashchain.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    byte[] _hidl_vec_element = new byte[32];
                    long _hidl_array_offset_1 = _hidl_index_0 * 32;
                    childBlob.copyToInt8Array(_hidl_array_offset_1, _hidl_vec_element, 32);
                    _hidl_array_offset_1 += 32L;
                    _hidl_out_hashchain.add(_hidl_vec_element);
                }
                ArrayList<byte[]> arrayList = _hidl_out_hashchain;
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                DebugInfo _hidl_out_info = new DebugInfo();
                _hidl_out_info.readFromParcel(_hidl_reply);
                DebugInfo debugInfo = _hidl_out_info;
                return debugInfo;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }

    @FunctionalInterface
    public static interface removeDownstreamCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface addDownstreamCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface setUpstreamParametersCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface setDataLimitCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface getForwardedStatsCallback {
        public void onValues(long var1, long var3);
    }

    @FunctionalInterface
    public static interface setLocalPrefixesCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface stopOffloadCallback {
        public void onValues(boolean var1, String var2);
    }

    @FunctionalInterface
    public static interface initOffloadCallback {
        public void onValues(boolean var1, String var2);
    }
}

