/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.thermal.V1_0;

import android.hardware.thermal.V1_0.TemperatureType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class Temperature {
    public int type;
    public String name = new String();
    public float currentValue;
    public float throttlingThreshold;
    public float shutdownThreshold;
    public float vrThrottlingThreshold;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != Temperature.class) {
            return false;
        }
        Temperature other = (Temperature)otherObject;
        if (this.type != other.type) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.name, other.name)) {
            return false;
        }
        if (this.currentValue != other.currentValue) {
            return false;
        }
        if (this.throttlingThreshold != other.throttlingThreshold) {
            return false;
        }
        if (this.shutdownThreshold != other.shutdownThreshold) {
            return false;
        }
        return this.vrThrottlingThreshold == other.vrThrottlingThreshold;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.name), HidlSupport.deepHashCode(Float.valueOf(this.currentValue)), HidlSupport.deepHashCode(Float.valueOf(this.throttlingThreshold)), HidlSupport.deepHashCode(Float.valueOf(this.shutdownThreshold)), HidlSupport.deepHashCode(Float.valueOf(this.vrThrottlingThreshold)));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".type = ");
        builder.append(TemperatureType.toString(this.type));
        builder.append(", .name = ");
        builder.append(this.name);
        builder.append(", .currentValue = ");
        builder.append(this.currentValue);
        builder.append(", .throttlingThreshold = ");
        builder.append(this.throttlingThreshold);
        builder.append(", .shutdownThreshold = ");
        builder.append(this.shutdownThreshold);
        builder.append(", .vrThrottlingThreshold = ");
        builder.append(this.vrThrottlingThreshold);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(40L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<Temperature> readVectorFromParcel(HwParcel parcel) {
        ArrayList<Temperature> _hidl_vec = new ArrayList<Temperature>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 40, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            Temperature _hidl_vec_element = new Temperature();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 40);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.type = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.name = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.name.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        this.currentValue = _hidl_blob.getFloat(_hidl_offset + 24L);
        this.throttlingThreshold = _hidl_blob.getFloat(_hidl_offset + 28L);
        this.shutdownThreshold = _hidl_blob.getFloat(_hidl_offset + 32L);
        this.vrThrottlingThreshold = _hidl_blob.getFloat(_hidl_offset + 36L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(40);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<Temperature> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 40);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 40);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.type);
        _hidl_blob.putString(_hidl_offset + 8L, this.name);
        _hidl_blob.putFloat(_hidl_offset + 24L, this.currentValue);
        _hidl_blob.putFloat(_hidl_offset + 28L, this.throttlingThreshold);
        _hidl_blob.putFloat(_hidl_offset + 32L, this.shutdownThreshold);
        _hidl_blob.putFloat(_hidl_offset + 36L, this.vrThrottlingThreshold);
    }
}

