/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.thermal.V2_0;

import android.hardware.thermal.V1_0.CpuUsage;
import android.hardware.thermal.V1_0.IThermal;
import android.hardware.thermal.V1_0.ThermalStatus;
import android.hardware.thermal.V2_0.CoolingDevice;
import android.hardware.thermal.V2_0.IThermalChangedCallback;
import android.hardware.thermal.V2_0.Temperature;
import android.hardware.thermal.V2_0.TemperatureThreshold;
import android.internal.hidl.base.V1_0.DebugInfo;
import android.os.HidlSupport;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.NativeHandle;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface IThermal
extends android.hardware.thermal.V1_0.IThermal {
    public static final String kInterfaceName = "android.hardware.thermal@2.0::IThermal";

    public static IThermal asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof IThermal) {
            return (IThermal)iface;
        }
        Proxy proxy = new Proxy(binder);
        try {
            for (String descriptor : proxy.interfaceChain()) {
                if (!descriptor.equals(kInterfaceName)) continue;
                return proxy;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public static IThermal castFrom(IHwInterface iface) {
        return iface == null ? null : IThermal.asInterface(iface.asBinder());
    }

    @Override
    public IHwBinder asBinder();

    public static IThermal getService(String serviceName, boolean retry) throws RemoteException {
        return IThermal.asInterface(HwBinder.getService(kInterfaceName, serviceName, retry));
    }

    public static IThermal getService(boolean retry) throws RemoteException {
        return IThermal.getService("default", retry);
    }

    public static IThermal getService(String serviceName) throws RemoteException {
        return IThermal.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static IThermal getService() throws RemoteException {
        return IThermal.getService("default");
    }

    public void getCurrentTemperatures(boolean var1, int var2, getCurrentTemperaturesCallback var3) throws RemoteException;

    public void getTemperatureThresholds(boolean var1, int var2, getTemperatureThresholdsCallback var3) throws RemoteException;

    public ThermalStatus registerThermalChangedCallback(IThermalChangedCallback var1, boolean var2, int var3) throws RemoteException;

    public ThermalStatus unregisterThermalChangedCallback(IThermalChangedCallback var1) throws RemoteException;

    public void getCurrentCoolingDevices(boolean var1, int var2, getCurrentCoolingDevicesCallback var3) throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public void debug(NativeHandle var1, ArrayList<String> var2) throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public ArrayList<byte[]> getHashChain() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements IThermal {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(IThermal.kInterfaceName, "android.hardware.thermal@1.0::IThermal", "android.hidl.base@1.0::IBase"));
        }

        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) {
        }

        @Override
        public final String interfaceDescriptor() {
            return IThermal.kInterfaceName;
        }

        @Override
        public final ArrayList<byte[]> getHashChain() {
            return new ArrayList<byte[]>(Arrays.asList({-67, -120, -76, -122, 57, -54, -29, 9, -126, 2, 16, 36, -30, 35, 113, 7, 108, 118, -6, -88, 70, 110, 56, -54, 89, -123, 41, 69, 43, 97, -114, -82}, {-105, -15, -20, 68, 96, 67, -68, 90, 102, 69, -73, 69, 41, -90, 39, 100, -106, -67, -77, 94, 10, -18, 65, -19, -91, 92, -71, 45, 81, -21, 120, 2}, {-20, 127, -41, -98, -48, 45, -6, -123, -68, 73, -108, 38, -83, -82, 62, -66, 35, -17, 5, 36, -13, -51, 105, 87, 19, -109, 36, -72, 59, 24, -54, 76}));
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = HidlSupport.getPidIfSharable();
            info.ptr = 0L;
            info.arch = 0;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            HwBinder.enableInstrumentation();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (IThermal.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(serviceName);
        }

        public String toString() {
            return this.interfaceDescriptor() + "@Stub";
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, final HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.thermal@1.0::IThermal");
                    this.getTemperatures(new IThermal.getTemperaturesCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<android.hardware.thermal.V1_0.Temperature> temperatures) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            android.hardware.thermal.V1_0.Temperature.writeVectorToParcel(_hidl_reply, temperatures);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 2: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.thermal@1.0::IThermal");
                    this.getCpuUsages(new IThermal.getCpuUsagesCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<CpuUsage> cpuUsages) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            CpuUsage.writeVectorToParcel(_hidl_reply, cpuUsages);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 3: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hardware.thermal@1.0::IThermal");
                    this.getCoolingDevices(new IThermal.getCoolingDevicesCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<android.hardware.thermal.V1_0.CoolingDevice> devices) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            android.hardware.thermal.V1_0.CoolingDevice.writeVectorToParcel(_hidl_reply, devices);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 4: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IThermal.kInterfaceName);
                    boolean filterType = _hidl_request.readBool();
                    int type = _hidl_request.readInt32();
                    this.getCurrentTemperatures(filterType, type, new getCurrentTemperaturesCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<Temperature> temperatures) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            Temperature.writeVectorToParcel(_hidl_reply, temperatures);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 5: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IThermal.kInterfaceName);
                    boolean filterType = _hidl_request.readBool();
                    int type = _hidl_request.readInt32();
                    this.getTemperatureThresholds(filterType, type, new getTemperatureThresholdsCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<TemperatureThreshold> temperatureThresholds) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            TemperatureThreshold.writeVectorToParcel(_hidl_reply, temperatureThresholds);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 6: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IThermal.kInterfaceName);
                    IThermalChangedCallback callback = IThermalChangedCallback.asInterface(_hidl_request.readStrongBinder());
                    boolean filterType = _hidl_request.readBool();
                    int type = _hidl_request.readInt32();
                    ThermalStatus _hidl_out_status = this.registerThermalChangedCallback(callback, filterType, type);
                    _hidl_reply.writeStatus(0);
                    _hidl_out_status.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 7: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IThermal.kInterfaceName);
                    IThermalChangedCallback callback = IThermalChangedCallback.asInterface(_hidl_request.readStrongBinder());
                    ThermalStatus _hidl_out_status = this.unregisterThermalChangedCallback(callback);
                    _hidl_reply.writeStatus(0);
                    _hidl_out_status.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 8: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface(IThermal.kInterfaceName);
                    boolean filterType = _hidl_request.readBool();
                    int type = _hidl_request.readInt32();
                    this.getCurrentCoolingDevices(filterType, type, new getCurrentCoolingDevicesCallback(){

                        @Override
                        public void onValues(ThermalStatus status, ArrayList<CoolingDevice> devices) {
                            _hidl_reply.writeStatus(0);
                            status.writeToParcel(_hidl_reply);
                            CoolingDevice.writeVectorToParcel(_hidl_reply, devices);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 256067662: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    NativeHandle fd = _hidl_request.readNativeHandle();
                    ArrayList<String> options = _hidl_request.readStringVector();
                    this.debug(fd, options);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256398152: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<byte[]> _hidl_out_hashchain = this.getHashChain();
                    _hidl_reply.writeStatus(0);
                    HwBlob _hidl_blob = new HwBlob(16);
                    int _hidl_vec_size = _hidl_out_hashchain.size();
                    _hidl_blob.putInt32(8L, _hidl_vec_size);
                    _hidl_blob.putBool(12L, false);
                    HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
                    for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                        long _hidl_array_offset_1 = _hidl_index_0 * 32;
                        byte[] _hidl_array_item_1 = _hidl_out_hashchain.get(_hidl_index_0);
                        if (_hidl_array_item_1 == null || _hidl_array_item_1.length != 32) {
                            throw new IllegalArgumentException("Array element is not of the expected length");
                        }
                        childBlob.putInt8Array(_hidl_array_offset_1, _hidl_array_item_1);
                        _hidl_array_offset_1 += 32L;
                    }
                    _hidl_blob.putBlob(0L, childBlob);
                    _hidl_reply.writeBuffer(_hidl_blob);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
                case 256921159: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.ping();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 257049926: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) {
                        _hidl_reply.writeStatus(Integer.MIN_VALUE);
                        _hidl_reply.send();
                        break;
                    }
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
                case 0xF555444: {
                    boolean _hidl_is_oneway;
                    boolean bl = _hidl_is_oneway = (_hidl_flags & 1) != 0;
                    if (!_hidl_is_oneway) break;
                    _hidl_reply.writeStatus(Integer.MIN_VALUE);
                    _hidl_reply.send();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements IThermal {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        public String toString() {
            try {
                return this.interfaceDescriptor() + "@Proxy";
            }
            catch (RemoteException remoteException) {
                return "[class or subclass of android.hardware.thermal@2.0::IThermal]@Proxy";
            }
        }

        public final boolean equals(Object other) {
            return HidlSupport.interfacesEqual(this, other);
        }

        public final int hashCode() {
            return this.asBinder().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getTemperatures(IThermal.getTemperaturesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.thermal@1.0::IThermal");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<android.hardware.thermal.V1_0.Temperature> _hidl_out_temperatures = android.hardware.thermal.V1_0.Temperature.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_temperatures);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getCpuUsages(IThermal.getCpuUsagesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.thermal@1.0::IThermal");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(2, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<CpuUsage> _hidl_out_cpuUsages = CpuUsage.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_cpuUsages);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getCoolingDevices(IThermal.getCoolingDevicesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hardware.thermal@1.0::IThermal");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(3, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<android.hardware.thermal.V1_0.CoolingDevice> _hidl_out_devices = android.hardware.thermal.V1_0.CoolingDevice.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_devices);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getCurrentTemperatures(boolean filterType, int type, getCurrentTemperaturesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IThermal.kInterfaceName);
            _hidl_request.writeBool(filterType);
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(4, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<Temperature> _hidl_out_temperatures = Temperature.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_temperatures);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getTemperatureThresholds(boolean filterType, int type, getTemperatureThresholdsCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IThermal.kInterfaceName);
            _hidl_request.writeBool(filterType);
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(5, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<TemperatureThreshold> _hidl_out_temperatureThresholds = TemperatureThreshold.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_temperatureThresholds);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ThermalStatus registerThermalChangedCallback(IThermalChangedCallback callback, boolean filterType, int type) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IThermal.kInterfaceName);
            _hidl_request.writeStrongBinder(callback == null ? null : callback.asBinder());
            _hidl_request.writeBool(filterType);
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(6, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ThermalStatus thermalStatus = _hidl_out_status;
                return thermalStatus;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ThermalStatus unregisterThermalChangedCallback(IThermalChangedCallback callback) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IThermal.kInterfaceName);
            _hidl_request.writeStrongBinder(callback == null ? null : callback.asBinder());
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(7, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ThermalStatus thermalStatus = _hidl_out_status;
                return thermalStatus;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getCurrentCoolingDevices(boolean filterType, int type, getCurrentCoolingDevicesCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IThermal.kInterfaceName);
            _hidl_request.writeBool(filterType);
            _hidl_request.writeInt32(type);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(8, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ThermalStatus _hidl_out_status = new ThermalStatus();
                _hidl_out_status.readFromParcel(_hidl_reply);
                ArrayList<CoolingDevice> _hidl_out_devices = CoolingDevice.readVectorFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_devices);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                ArrayList<String> _hidl_out_descriptors;
                this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<String> arrayList = _hidl_out_descriptors = _hidl_reply.readStringVector();
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void debug(NativeHandle fd, ArrayList<String> options) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            _hidl_request.writeNativeHandle(fd);
            _hidl_request.writeStringVector(options);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256131655, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                String _hidl_out_descriptor;
                this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                String string2 = _hidl_out_descriptor = _hidl_reply.readString();
                return string2;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<byte[]> getHashChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256398152, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<byte[]> _hidl_out_hashchain = new ArrayList<byte[]>();
                HwBlob _hidl_blob = _hidl_reply.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = _hidl_reply.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
                _hidl_out_hashchain.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    byte[] _hidl_vec_element = new byte[32];
                    long _hidl_array_offset_1 = _hidl_index_0 * 32;
                    childBlob.copyToInt8Array(_hidl_array_offset_1, _hidl_vec_element, 32);
                    _hidl_array_offset_1 += 32L;
                    _hidl_out_hashchain.add(_hidl_vec_element);
                }
                ArrayList<byte[]> arrayList = _hidl_out_hashchain;
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                DebugInfo _hidl_out_info = new DebugInfo();
                _hidl_out_info.readFromParcel(_hidl_reply);
                DebugInfo debugInfo = _hidl_out_info;
                return debugInfo;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }

    @FunctionalInterface
    public static interface getCurrentCoolingDevicesCallback {
        public void onValues(ThermalStatus var1, ArrayList<CoolingDevice> var2);
    }

    @FunctionalInterface
    public static interface getTemperatureThresholdsCallback {
        public void onValues(ThermalStatus var1, ArrayList<TemperatureThreshold> var2);
    }

    @FunctionalInterface
    public static interface getCurrentTemperaturesCallback {
        public void onValues(ThermalStatus var1, ArrayList<Temperature> var2);
    }
}

